/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateReadOnly;

public class OneDoFJointState
extends JointStateBase
implements OneDoFJointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private double configuration = 0.0;
    private double velocity = 0.0;
    private double acceleration = 0.0;
    private double effort = 0.0;
    private final DMatrixRMaj temp = new DMatrixRMaj(1, 1);

    public OneDoFJointState() {
    }

    public OneDoFJointState(double q) {
        this.setConfiguration(q);
    }

    public OneDoFJointState(double q, double qd) {
        this.setConfiguration(q);
        this.setVelocity(qd);
    }

    public OneDoFJointState(double q, double qd, double tau) {
        this.setConfiguration(q);
        this.setVelocity(qd);
        this.setEffort(tau);
    }

    public OneDoFJointState(JointStateReadOnly other) {
        this.set(other);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    public void set(OneDoFJointState other) {
        this.configuration = other.configuration;
        this.velocity = other.velocity;
        this.acceleration = other.acceleration;
        this.effort = other.effort;
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof OneDoFJointState) {
            this.set((OneDoFJointState)jointStateReadOnly);
        } else if (jointStateReadOnly instanceof OneDoFJointStateReadOnly) {
            OneDoFJointStateBasics.super.set((OneDoFJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            this.clear();
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            }
        }
    }

    @Override
    public void setConfiguration(double q) {
        this.availableStates.add(JointStateType.CONFIGURATION);
        this.configuration = q;
    }

    @Override
    public void setVelocity(double qd) {
        this.availableStates.add(JointStateType.VELOCITY);
        this.velocity = qd;
    }

    @Override
    public void setAcceleration(double qdd) {
        this.availableStates.add(JointStateType.ACCELERATION);
        this.acceleration = qdd;
    }

    @Override
    public void setEffort(double tau) {
        this.availableStates.add(JointStateType.EFFORT);
        this.effort = tau;
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public double getConfiguration() {
        return this.configuration;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    @Override
    public double getAcceleration() {
        return this.acceleration;
    }

    @Override
    public double getEffort() {
        return this.effort;
    }

    @Override
    public OneDoFJointState copy() {
        return new OneDoFJointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.availableStates);
        if (this.availableStates.contains(JointStateType.CONFIGURATION)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.configuration);
        }
        if (this.availableStates.contains(JointStateType.VELOCITY)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.velocity);
        }
        if (this.availableStates.contains(JointStateType.ACCELERATION)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.acceleration);
        }
        if (this.availableStates.contains(JointStateType.EFFORT)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.effort);
        }
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OneDoFJointState other = (OneDoFJointState)object;
        if (!Objects.equals(this.availableStates, other.availableStates)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.CONFIGURATION) && Double.doubleToLongBits(this.configuration) != Double.doubleToLongBits(other.configuration)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.VELOCITY) && Double.doubleToLongBits(this.velocity) != Double.doubleToLongBits(other.velocity)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.ACCELERATION) && Double.doubleToLongBits(this.acceleration) != Double.doubleToLongBits(other.acceleration)) {
            return false;
        }
        return !this.availableStates.contains(JointStateType.EFFORT) || Double.doubleToLongBits(this.effort) == Double.doubleToLongBits(other.effort);
    }
}

