/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public class JointState
extends JointStateBase
implements JointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private final DMatrixRMaj configuration;
    private final DMatrixRMaj velocity;
    private final DMatrixRMaj acceleration;
    private final DMatrixRMaj effort;
    private final int configurationSize;
    private final int degreesOfFreedom;

    public JointState(int configurationSize, int degreesOfFreedom) {
        this.configurationSize = configurationSize;
        this.degreesOfFreedom = degreesOfFreedom;
        this.configuration = new DMatrixRMaj(configurationSize, 1);
        this.velocity = new DMatrixRMaj(degreesOfFreedom, 1);
        this.acceleration = new DMatrixRMaj(degreesOfFreedom, 1);
        this.effort = new DMatrixRMaj(degreesOfFreedom, 1);
    }

    public JointState(JointState other) {
        this.configurationSize = other.configurationSize;
        this.degreesOfFreedom = other.degreesOfFreedom;
        this.configuration = new DMatrixRMaj(other.configuration);
        this.velocity = new DMatrixRMaj(other.velocity);
        this.acceleration = new DMatrixRMaj(other.acceleration);
        this.effort = new DMatrixRMaj(other.effort);
        this.availableStates.addAll(other.availableStates);
    }

    public JointState(JointStateReadOnly other) {
        this(other.getConfigurationSize(), other.getDegreesOfFreedom());
        this.set(other);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    @Override
    public void set(JointStateReadOnly other) {
        if (other.getConfigurationSize() != this.configurationSize || other.getDegreesOfFreedom() != this.degreesOfFreedom) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        this.clear();
        if (other.hasOutputFor(JointStateType.CONFIGURATION)) {
            other.getConfiguration(0, (DMatrix)this.configuration);
            this.availableStates.add(JointStateType.CONFIGURATION);
        }
        if (other.hasOutputFor(JointStateType.VELOCITY)) {
            other.getVelocity(0, (DMatrix)this.velocity);
            this.availableStates.add(JointStateType.VELOCITY);
        }
        if (other.hasOutputFor(JointStateType.ACCELERATION)) {
            other.getAcceleration(0, (DMatrix)this.acceleration);
            this.availableStates.add(JointStateType.ACCELERATION);
        }
        if (other.hasOutputFor(JointStateType.EFFORT)) {
            other.getEffort(0, (DMatrix)this.effort);
            this.availableStates.add(JointStateType.EFFORT);
        }
    }

    @Override
    public int getConfigurationSize() {
        return this.configurationSize;
    }

    @Override
    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public void setConfiguration(JointReadOnly joint) {
        this.checkConfigurationSize(joint);
        this.availableStates.add(JointStateType.CONFIGURATION);
        joint.getJointConfiguration(0, (DMatrix)this.configuration);
    }

    @Override
    public int setConfiguration(int startRow, DMatrix configuration) {
        CommonOps_DDRM.extract((DMatrix)configuration, (int)startRow, (int)(startRow + this.getConfigurationSize()), (int)0, (int)1, (DMatrix)this.configuration);
        this.availableStates.add(JointStateType.CONFIGURATION);
        return startRow + this.getConfigurationSize();
    }

    @Override
    public void setVelocity(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.availableStates.add(JointStateType.VELOCITY);
        this.velocity.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointVelocity(0, (DMatrix)this.velocity);
    }

    @Override
    public int setVelocity(int startRow, DMatrix velocity) {
        CommonOps_DDRM.extract((DMatrix)velocity, (int)startRow, (int)(startRow + this.getDegreesOfFreedom()), (int)0, (int)1, (DMatrix)this.velocity);
        this.availableStates.add(JointStateType.VELOCITY);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setAcceleration(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.availableStates.add(JointStateType.ACCELERATION);
        this.acceleration.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointAcceleration(0, (DMatrix)this.acceleration);
    }

    @Override
    public int setAcceleration(int startRow, DMatrix acceleration) {
        CommonOps_DDRM.extract((DMatrix)acceleration, (int)startRow, (int)(startRow + this.getDegreesOfFreedom()), (int)0, (int)1, (DMatrix)this.acceleration);
        this.availableStates.add(JointStateType.ACCELERATION);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setEffort(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.availableStates.add(JointStateType.EFFORT);
        this.effort.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointTau(0, (DMatrix)this.effort);
    }

    @Override
    public int setEffort(int startRow, DMatrix effort) {
        CommonOps_DDRM.extract((DMatrix)effort, (int)startRow, (int)(startRow + this.getDegreesOfFreedom()), (int)0, (int)1, (DMatrix)this.effort);
        this.availableStates.add(JointStateType.EFFORT);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public int getConfiguration(int startRow, DMatrix configurationToPack) {
        CommonOps_DDRM.insert((DMatrix)this.configuration, (DMatrix)configurationToPack, (int)startRow, (int)0);
        return startRow + this.configuration.getNumRows();
    }

    @Override
    public int getVelocity(int startRow, DMatrix velocityToPack) {
        CommonOps_DDRM.insert((DMatrix)this.velocity, (DMatrix)velocityToPack, (int)startRow, (int)0);
        return startRow + this.velocity.getNumRows();
    }

    @Override
    public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        CommonOps_DDRM.insert((DMatrix)this.acceleration, (DMatrix)accelerationToPack, (int)startRow, (int)0);
        return startRow + this.acceleration.getNumRows();
    }

    @Override
    public int getEffort(int startRow, DMatrix effortToPack) {
        CommonOps_DDRM.insert((DMatrix)this.effort, (DMatrix)effortToPack, (int)startRow, (int)0);
        return startRow + this.effort.getNumRows();
    }

    @Override
    public void getConfiguration(JointBasics jointToUpdate) {
        jointToUpdate.setJointConfiguration(0, (DMatrix)this.configuration);
    }

    @Override
    public void getVelocity(JointBasics jointToUpdate) {
        jointToUpdate.setJointVelocity(0, (DMatrix)this.velocity);
    }

    @Override
    public void getAcceleration(JointBasics jointToUpdate) {
        jointToUpdate.setJointAcceleration(0, (DMatrix)this.acceleration);
    }

    @Override
    public void getEffort(JointBasics jointToUpdate) {
        jointToUpdate.setJointTau(0, (DMatrix)this.effort);
    }

    public DMatrixRMaj getConfiguration() {
        return this.configuration;
    }

    public DMatrixRMaj getVelocity() {
        return this.velocity;
    }

    public DMatrixRMaj getAcceleration() {
        return this.acceleration;
    }

    public DMatrixRMaj getEffort() {
        return this.effort;
    }

    @Override
    public JointState copy() {
        return new JointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.availableStates);
        if (this.availableStates.contains(JointStateType.CONFIGURATION)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.configuration.getData());
        }
        if (this.availableStates.contains(JointStateType.VELOCITY)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.velocity.getData());
        }
        if (this.availableStates.contains(JointStateType.ACCELERATION)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.acceleration.getData());
        }
        if (this.availableStates.contains(JointStateType.EFFORT)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.effort.getData());
        }
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.configurationSize);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.degreesOfFreedom);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JointState other = (JointState)object;
        if (!Objects.equals(this.availableStates, other.availableStates)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.CONFIGURATION) && !Objects.equals(this.configuration, other.configuration)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.VELOCITY) && !Objects.equals(this.velocity, other.velocity)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.ACCELERATION) && !Objects.equals(this.acceleration, other.acceleration)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.EFFORT) && !Objects.equals(this.effort, other.effort)) {
            return false;
        }
        if (this.configurationSize != other.configurationSize) {
            return false;
        }
        return this.degreesOfFreedom == other.degreesOfFreedom;
    }
}

