/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;

public class SensorDefinition
implements Transformable {
    private String name;
    private YawPitchRollTransformDefinition transformToJoint = new YawPitchRollTransformDefinition();
    private int updatePeriod;

    public SensorDefinition() {
    }

    public SensorDefinition(String name, Tuple3DReadOnly offsetFromJoint) {
        this.name = name;
        this.transformToJoint.setTranslationAndIdentityRotation(offsetFromJoint);
    }

    public SensorDefinition(String name, RigidBodyTransformReadOnly transformToJoint) {
        this.name = name;
        this.transformToJoint.set(transformToJoint);
    }

    public SensorDefinition(SensorDefinition other) {
        this.name = other.name;
        this.transformToJoint.set((RigidBodyTransformReadOnly)other.transformToJoint);
        this.updatePeriod = other.updatePeriod;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement
    public void setName(String name) {
        this.name = name;
    }

    public YawPitchRollTransformDefinition getTransformToJoint() {
        return this.transformToJoint;
    }

    public void setOffsetFromJoint(Tuple3DReadOnly offsetFromJoint) {
        this.transformToJoint.setTranslationAndIdentityRotation(offsetFromJoint);
    }

    @XmlElement
    public void setTransformToJoint(YawPitchRollTransformDefinition transformToJoint) {
        this.transformToJoint = transformToJoint;
    }

    public void setTransformToJoint(RigidBodyTransformReadOnly transformToJoint) {
        this.transformToJoint.set(transformToJoint);
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    @XmlElement
    public void setUpdatePeriod(int updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public SensorDefinition copy() {
        return new SensorDefinition(this);
    }

    public void applyTransform(Transform transform) {
        transform.transform((RigidBodyTransformBasics)this.transformToJoint);
    }

    public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((RigidBodyTransformBasics)this.transformToJoint);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.name;
    }
}

