/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;

public class CrossFourBarJointDefinition
extends OneDoFJointDefinition {
    private String jointNameA;
    private String jointNameB;
    private String jointNameC;
    private String jointNameD;
    private YawPitchRollTransformDefinition transformAToPredecessor = new YawPitchRollTransformDefinition();
    private YawPitchRollTransformDefinition transformBToPredecessor = new YawPitchRollTransformDefinition();
    private YawPitchRollTransformDefinition transformCToB = new YawPitchRollTransformDefinition();
    private YawPitchRollTransformDefinition transformDToA = new YawPitchRollTransformDefinition();
    private RigidBodyDefinition bodyDA = new RigidBodyDefinition();
    private RigidBodyDefinition bodyBC = new RigidBodyDefinition();
    private int actuatedJointIndex;
    private int loopClosureJointIndex;

    public CrossFourBarJointDefinition(String name) {
        super(name);
        this.bodyDA.setName(name + "_DA");
        this.bodyBC.setName(name + "_BC");
    }

    public CrossFourBarJointDefinition(String name, Vector3DReadOnly axis) {
        this(name);
        this.setAxis(axis);
    }

    public void setJointNameA(String jointNameA) {
        this.jointNameA = jointNameA;
    }

    public void setJointNameB(String jointNameB) {
        this.jointNameB = jointNameB;
    }

    public void setJointNameC(String jointNameC) {
        this.jointNameC = jointNameC;
    }

    public void setJointNameD(String jointNameD) {
        this.jointNameD = jointNameD;
    }

    public void setJointNames(String jointNameA, String jointNameB, String jointNameC, String jointNameD) {
        this.jointNameA = jointNameA;
        this.jointNameB = jointNameB;
        this.jointNameC = jointNameC;
        this.jointNameD = jointNameD;
    }

    public void setTransformAToPredecessor(YawPitchRollTransformDefinition transformAToPredecessor) {
        this.transformAToPredecessor = transformAToPredecessor;
    }

    public void setTransformAToPredecessor(RigidBodyTransformReadOnly transformAToPredecessor) {
        this.transformAToPredecessor.set(transformAToPredecessor);
    }

    public void setTransformBToPredecessor(YawPitchRollTransformDefinition transformBToPredecessor) {
        this.transformBToPredecessor = transformBToPredecessor;
    }

    public void setTransformBToPredecessor(RigidBodyTransformReadOnly transformBToPredecessor) {
        this.transformBToPredecessor.set(transformBToPredecessor);
    }

    public void setTransformCToB(YawPitchRollTransformDefinition transformCToB) {
        this.transformCToB = transformCToB;
    }

    public void setTransformCToB(RigidBodyTransformReadOnly transformCToB) {
        this.transformCToB.set(transformCToB);
    }

    public void setTransformDToA(YawPitchRollTransformDefinition transformDToA) {
        this.transformDToA = transformDToA;
    }

    public void setTransformDToA(RigidBodyTransformReadOnly transformDToA) {
        this.transformDToA.set(transformDToA);
    }

    public void setJointTransforms(RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToPredecessor, RigidBodyTransformReadOnly transformCToB, RigidBodyTransformReadOnly transformDToA) {
        this.transformAToPredecessor.set(transformAToPredecessor);
        this.transformBToPredecessor.set(transformBToPredecessor);
        this.transformCToB.set(transformCToB);
        this.transformDToA.set(transformDToA);
    }

    public void setBodyDA(RigidBodyDefinition bodyDA) {
        this.bodyDA = bodyDA;
    }

    public void setBodyBC(RigidBodyDefinition bodyBC) {
        this.bodyBC = bodyBC;
    }

    public void setActuatedJointIndex(int actuatedJointIndex) {
        this.actuatedJointIndex = actuatedJointIndex;
    }

    public void setLoopClosureJointIndex(int loopClosureJointIndex) {
        this.loopClosureJointIndex = loopClosureJointIndex;
    }

    public String getJointNameA() {
        return this.jointNameA;
    }

    public String getJointNameB() {
        return this.jointNameB;
    }

    public String getJointNameC() {
        return this.jointNameC;
    }

    public String getJointNameD() {
        return this.jointNameD;
    }

    public YawPitchRollTransformDefinition getTransformAToPredecessor() {
        return this.transformAToPredecessor;
    }

    public YawPitchRollTransformDefinition getTransformBToPredecessor() {
        return this.transformBToPredecessor;
    }

    public YawPitchRollTransformDefinition getTransformCToB() {
        return this.transformCToB;
    }

    public YawPitchRollTransformDefinition getTransformDToA() {
        return this.transformDToA;
    }

    public RigidBodyDefinition getBodyDA() {
        return this.bodyDA;
    }

    public RigidBodyDefinition getBodyBC() {
        return this.bodyBC;
    }

    public int getActuatedJointIndex() {
        return this.actuatedJointIndex;
    }

    public int getLoopClosureJointIndex() {
        return this.loopClosureJointIndex;
    }

    public CrossFourBarJoint toJoint(RigidBodyBasics predecessor) {
        return new CrossFourBarJoint(this.getName(), predecessor, this.jointNameA, this.jointNameB, this.jointNameC, this.jointNameD, this.bodyDA.getName(), this.bodyBC.getName(), (RigidBodyTransformReadOnly)this.transformAToPredecessor, (RigidBodyTransformReadOnly)this.transformBToPredecessor, (RigidBodyTransformReadOnly)this.transformDToA, (RigidBodyTransformReadOnly)this.transformCToB, (Matrix3DReadOnly)this.bodyDA.getMomentOfInertia(), (Matrix3DReadOnly)this.bodyBC.getMomentOfInertia(), this.bodyDA.getMass(), this.bodyBC.getMass(), (RigidBodyTransformReadOnly)this.bodyDA.getInertiaPose(), (RigidBodyTransformReadOnly)this.bodyBC.getInertiaPose(), this.actuatedJointIndex, this.loopClosureJointIndex, (Vector3DReadOnly)this.getAxis());
    }

    @Override
    public CrossFourBarJointDefinition copy() {
        CrossFourBarJointDefinition clone = new CrossFourBarJointDefinition(this.getName(), (Vector3DReadOnly)this.getAxis());
        clone.jointNameA = this.jointNameA;
        clone.jointNameB = this.jointNameB;
        clone.jointNameC = this.jointNameC;
        clone.jointNameD = this.jointNameD;
        clone.transformAToPredecessor.set((RigidBodyTransformReadOnly)this.transformAToPredecessor);
        clone.transformBToPredecessor.set((RigidBodyTransformReadOnly)this.transformBToPredecessor);
        clone.transformCToB.set((RigidBodyTransformReadOnly)this.transformCToB);
        clone.transformDToA.set((RigidBodyTransformReadOnly)this.transformDToA);
        clone.bodyDA = this.bodyDA.copy();
        clone.bodyBC = this.bodyBC.copy();
        clone.actuatedJointIndex = this.actuatedJointIndex;
        clone.loopClosureJointIndex = this.loopClosureJointIndex;
        return clone;
    }
}

