/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Torus3DDefinition
extends GeometryDefinition {
    private double majorRadius;
    private double minorRadius;
    private int resolution = 64;

    public Torus3DDefinition() {
        this.setName("torus");
    }

    public Torus3DDefinition(double majorRadius, double minorRadius) {
        this();
        this.majorRadius = majorRadius;
        this.minorRadius = minorRadius;
    }

    public Torus3DDefinition(double majorRadius, double minorRadius, int resolution) {
        this();
        this.majorRadius = majorRadius;
        this.minorRadius = minorRadius;
        this.resolution = resolution;
    }

    public Torus3DDefinition(Torus3DDefinition other) {
        this.setName(other.getName());
        this.majorRadius = other.majorRadius;
        this.minorRadius = other.minorRadius;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setMajorRadius(double majorRadius) {
        this.majorRadius = majorRadius;
    }

    @XmlElement
    public void setMinorRadius(double minorRadius) {
        this.minorRadius = minorRadius;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getMajorRadius() {
        return this.majorRadius;
    }

    public double getMinorRadius() {
        return this.minorRadius;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public Torus3DDefinition copy() {
        return new Torus3DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.majorRadius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minorRadius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (float)this.resolution);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Torus3DDefinition) {
            Torus3DDefinition other = (Torus3DDefinition)object;
            if (this.majorRadius != other.majorRadius) {
                return false;
            }
            if (this.minorRadius != other.minorRadius) {
                return false;
            }
            if (this.resolution != other.resolution) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "Torus: [name: " + this.getName() + EuclidCoreIOTools.getStringOf((String)", radii: (", (String)")", (String)", ", (double[])new double[]{this.majorRadius, this.minorRadius}) + ", resolution: " + this.resolution + "]";
    }
}

