/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Sphere3DDefinition
extends GeometryDefinition {
    private double radius;
    private int resolution = 64;

    public Sphere3DDefinition() {
        this.setName("sphere");
    }

    public Sphere3DDefinition(double radius) {
        this();
        this.radius = radius;
    }

    public Sphere3DDefinition(double radius, int resolution) {
        this();
        this.radius = radius;
        this.resolution = resolution;
    }

    public Sphere3DDefinition(Sphere3DDefinition other) {
        this.setName(other.getName());
        this.radius = other.radius;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public Sphere3DDefinition copy() {
        return new Sphere3DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (float)this.resolution);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Sphere3DDefinition) {
            Sphere3DDefinition other = (Sphere3DDefinition)object;
            if (this.radius != other.radius) {
                return false;
            }
            if (this.resolution != other.resolution) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "Sphere: [name: " + this.getName() + ", radius: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.radius) + ", resolution: " + this.resolution + "]";
    }
}

