/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;

public class STPCylinder3DDefinition
extends Cylinder3DDefinition {
    private double minimumMargin;
    private double maximumMargin;

    public STPCylinder3DDefinition() {
    }

    public STPCylinder3DDefinition(Cylinder3DDefinition other) {
        super(other);
    }

    public STPCylinder3DDefinition(STPCylinder3DDefinition other) {
        super(other);
        this.setMargins(other.minimumMargin, other.maximumMargin);
    }

    public STPCylinder3DDefinition(double length, double radius, boolean centered, int resolution) {
        super(length, radius, centered, resolution);
    }

    public STPCylinder3DDefinition(double length, double radius, boolean centered) {
        super(length, radius, centered);
    }

    public STPCylinder3DDefinition(double length, double radius, int resolution) {
        super(length, radius, resolution);
    }

    public STPCylinder3DDefinition(double length, double radius) {
        super(length, radius);
    }

    public void setMargins(double minimumMargin, double maximumMargin) {
        this.setMinimumMargin(minimumMargin);
        this.setMaximumMargin(maximumMargin);
    }

    @XmlElement
    public void setMinimumMargin(double minimumMargin) {
        this.minimumMargin = minimumMargin;
    }

    @XmlElement
    public void setMaximumMargin(double maximumMargin) {
        this.maximumMargin = maximumMargin;
    }

    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public STPCylinder3DDefinition copy() {
        return new STPCylinder3DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.getLength());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.getRadius());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.isCentered());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (float)this.getResolution());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minimumMargin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.maximumMargin);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof STPCylinder3DDefinition) {
            STPCylinder3DDefinition other = (STPCylinder3DDefinition)object;
            if (this.minimumMargin != other.minimumMargin) {
                return false;
            }
            if (this.maximumMargin != other.maximumMargin) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    @Override
    public String toString() {
        return "STP" + super.toString().replace("]", "") + EuclidCoreIOTools.getStringOf((String)", margins: (", (String)")]", (String)", ", (double[])new double[]{this.minimumMargin, this.maximumMargin});
    }
}

