/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateReadOnly;

public class SixDoFJointState
extends JointStateBase
implements SixDoFJointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private final Pose3D configuration = new Pose3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D linearVelocity = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D linearAcceleration = new Vector3D();
    private final Vector3D torque = new Vector3D();
    private final Vector3D force = new Vector3D();
    private final DMatrixRMaj temp = new DMatrixRMaj(7, 1);

    public SixDoFJointState() {
    }

    public SixDoFJointState(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        this.setConfiguration(orientation, position);
    }

    public SixDoFJointState(JointStateReadOnly other) {
        this.set(other);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    public void set(SixDoFJointState other) {
        this.configuration.set(other.configuration);
        this.angularVelocity.set(other.angularVelocity);
        this.linearVelocity.set(other.linearVelocity);
        this.angularAcceleration.set(other.angularAcceleration);
        this.linearAcceleration.set(other.linearAcceleration);
        this.torque.set(other.torque);
        this.force.set(other.force);
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof SixDoFJointState) {
            this.set((SixDoFJointState)jointStateReadOnly);
        } else if (jointStateReadOnly instanceof SixDoFJointStateReadOnly) {
            SixDoFJointStateBasics.super.set((SixDoFJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            this.clear();
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            }
        }
    }

    @Override
    public void setConfiguration(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        this.availableStates.add(JointStateType.CONFIGURATION);
        if (orientation != null) {
            this.configuration.getOrientation().set(orientation);
        } else {
            this.configuration.getOrientation().setToZero();
        }
        if (position != null) {
            this.configuration.getPosition().set(position);
        } else {
            this.configuration.getPosition().setToZero();
        }
    }

    @Override
    public int setConfiguration(int startRow, DMatrix configuration) {
        this.configuration.getOrientation().set(startRow, configuration);
        this.configuration.getPosition().set(startRow + 4, configuration);
        this.availableStates.add(JointStateType.CONFIGURATION);
        return startRow + this.getConfigurationSize();
    }

    @Override
    public void setVelocity(Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity) {
        this.availableStates.add(JointStateType.VELOCITY);
        if (angularVelocity == null) {
            this.angularVelocity.setToZero();
        } else {
            this.angularVelocity.set((Tuple3DReadOnly)angularVelocity);
        }
        if (linearVelocity == null) {
            this.linearVelocity.setToZero();
        } else {
            this.linearVelocity.set((Tuple3DReadOnly)linearVelocity);
        }
    }

    @Override
    public int setVelocity(int startRow, DMatrix velocity) {
        this.angularVelocity.set(startRow, velocity);
        this.linearVelocity.set(startRow + 3, velocity);
        this.availableStates.add(JointStateType.VELOCITY);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setAcceleration(Vector3DReadOnly angularAcceleration, Vector3DReadOnly linearAcceleration) {
        this.availableStates.add(JointStateType.ACCELERATION);
        if (angularAcceleration != null) {
            this.angularAcceleration.set((Tuple3DReadOnly)angularAcceleration);
        } else {
            this.angularAcceleration.setToZero();
        }
        if (linearAcceleration != null) {
            this.linearAcceleration.set((Tuple3DReadOnly)linearAcceleration);
        } else {
            this.linearAcceleration.setToZero();
        }
    }

    @Override
    public int setAcceleration(int startRow, DMatrix acceleration) {
        this.angularAcceleration.set(startRow, acceleration);
        this.linearAcceleration.set(startRow + 3, acceleration);
        this.availableStates.add(JointStateType.ACCELERATION);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setEffort(Vector3DReadOnly torque, Vector3DReadOnly force) {
        this.availableStates.add(JointStateType.EFFORT);
        if (torque != null) {
            this.torque.set((Tuple3DReadOnly)torque);
        } else {
            this.torque.setToZero();
        }
        if (force != null) {
            this.force.set((Tuple3DReadOnly)force);
        } else {
            this.force.setToZero();
        }
    }

    @Override
    public int setEffort(int startRow, DMatrix effort) {
        this.torque.set(startRow, effort);
        this.force.set(startRow + 3, effort);
        this.availableStates.add(JointStateType.EFFORT);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public Pose3DReadOnly getConfiguration() {
        return this.configuration;
    }

    @Override
    public Vector3DReadOnly getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public Vector3DReadOnly getLinearVelocity() {
        return this.linearVelocity;
    }

    @Override
    public Vector3DReadOnly getAngularAcceleration() {
        return this.angularAcceleration;
    }

    @Override
    public Vector3DReadOnly getLinearAcceleration() {
        return this.linearAcceleration;
    }

    @Override
    public Vector3DReadOnly getTorque() {
        return this.torque;
    }

    @Override
    public Vector3DReadOnly getForce() {
        return this.force;
    }

    @Override
    public SixDoFJointState copy() {
        return new SixDoFJointState(this);
    }
}

