/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.PlanarJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.PlanarJointStateReadOnly;

public class PlanarJointState
implements PlanarJointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private double pitch = Double.NaN;
    private double positionX = Double.NaN;
    private double positionZ = Double.NaN;
    private double pitchVelocity = Double.NaN;
    private double linearVelocityX = Double.NaN;
    private double linearVelocityZ = Double.NaN;
    private double pitchAcceleration = Double.NaN;
    private double linearAccelerationX = Double.NaN;
    private double linearAccelerationZ = Double.NaN;
    private double torqueY = Double.NaN;
    private double forceX = Double.NaN;
    private double forceZ = Double.NaN;
    private final DMatrixRMaj temp = new DMatrixRMaj(3, 1);

    public PlanarJointState() {
    }

    public PlanarJointState(JointStateReadOnly other) {
        this.set(other);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    public void set(PlanarJointState other) {
        this.pitch = other.pitch;
        this.positionX = other.positionX;
        this.positionZ = other.positionZ;
        this.pitchVelocity = other.pitchVelocity;
        this.linearVelocityX = other.linearVelocityX;
        this.linearVelocityZ = other.linearVelocityZ;
        this.pitchAcceleration = other.pitchAcceleration;
        this.linearAccelerationX = other.linearAccelerationX;
        this.linearAccelerationZ = other.linearAccelerationZ;
        this.torqueY = other.torqueY;
        this.forceX = other.forceX;
        this.forceZ = other.forceZ;
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof PlanarJointState) {
            this.set((PlanarJointState)jointStateReadOnly);
        } else if (jointStateReadOnly instanceof PlanarJointStateReadOnly) {
            PlanarJointStateBasics.super.set((PlanarJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            this.clear();
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            }
        }
    }

    @Override
    public void setConfiguration(double pitch, double positionX, double positionZ) {
        this.pitch = pitch;
        this.positionX = positionX;
        this.positionZ = positionZ;
        this.availableStates.add(JointStateType.CONFIGURATION);
    }

    @Override
    public void setVelocity(double pitchVelocity, double linearVelocityX, double linearVelocityZ) {
        this.pitchVelocity = pitchVelocity;
        this.linearVelocityX = linearVelocityX;
        this.linearVelocityZ = linearVelocityZ;
        this.availableStates.add(JointStateType.VELOCITY);
    }

    @Override
    public void setAcceleration(double pitchAcceleration, double linearAccelerationX, double linearAccelerationZ) {
        this.pitchAcceleration = pitchAcceleration;
        this.linearAccelerationX = linearAccelerationX;
        this.linearAccelerationZ = linearAccelerationZ;
        this.availableStates.add(JointStateType.ACCELERATION);
    }

    @Override
    public void setEffort(double torqueY, double forceX, double forceZ) {
        this.torqueY = torqueY;
        this.forceX = forceX;
        this.forceZ = forceZ;
        this.availableStates.add(JointStateType.EFFORT);
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public double getPitch() {
        return this.pitch;
    }

    @Override
    public double getPositionX() {
        return this.positionX;
    }

    @Override
    public double getPositionZ() {
        return this.positionZ;
    }

    @Override
    public double getPitchVelocity() {
        return this.pitchVelocity;
    }

    @Override
    public double getLinearVelocityX() {
        return this.linearVelocityX;
    }

    @Override
    public double getLinearVelocityZ() {
        return this.linearVelocityZ;
    }

    @Override
    public double getPitchAcceleration() {
        return this.pitchAcceleration;
    }

    @Override
    public double getLinearAccelerationX() {
        return this.linearAccelerationX;
    }

    @Override
    public double getLinearAccelerationZ() {
        return this.linearAccelerationZ;
    }

    @Override
    public double getTorqueY() {
        return this.torqueY;
    }

    @Override
    public double getForceX() {
        return this.forceX;
    }

    @Override
    public double getForceZ() {
        return this.forceZ;
    }

    @Override
    public PlanarJointState copy() {
        return new PlanarJointState(this);
    }
}

