/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class HemiEllipsoid3DDefinition
extends GeometryDefinition {
    private double radiusX;
    private double radiusY;
    private double radiusZ;
    private int resolution = 64;

    public HemiEllipsoid3DDefinition() {
        this.setName("hemiEllipsoid");
    }

    public HemiEllipsoid3DDefinition(double radiusX, double radiusY, double radiusZ) {
        this();
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
    }

    public HemiEllipsoid3DDefinition(double radiusX, double radiusY, double radiusZ, int resolution) {
        this();
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        this.resolution = resolution;
    }

    public HemiEllipsoid3DDefinition(HemiEllipsoid3DDefinition other) {
        this.setName(other.getName());
        this.radiusX = other.radiusX;
        this.radiusY = other.radiusY;
        this.radiusZ = other.radiusZ;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    @XmlElement
    public void setRadiusY(double radiusY) {
        this.radiusY = radiusY;
    }

    @XmlElement
    public void setRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
    }

    public void setRadii(double radiusX, double radiusY, double radiusZ) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public HemiEllipsoid3DDefinition copy() {
        return new HemiEllipsoid3DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.radiusZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (float)this.resolution);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HemiEllipsoid3DDefinition) {
            HemiEllipsoid3DDefinition other = (HemiEllipsoid3DDefinition)object;
            if (this.radiusX != other.radiusX) {
                return false;
            }
            if (this.radiusY != other.radiusY) {
                return false;
            }
            if (this.radiusZ != other.radiusZ) {
                return false;
            }
            if (this.resolution != other.resolution) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        return EuclidCoreIOTools.getStringOf((String)("Hemi-ellipsoid: [name: " + this.getName() + ", radii: ("), (String)("), resolution: " + this.resolution + "]"), (String)", ", (double[])new double[]{this.radiusX, this.radiusY, this.radiusZ});
    }
}

