/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.PlanarJointStateReadOnly;

public interface PlanarJointStateBasics
extends PlanarJointStateReadOnly,
JointStateBasics {
    public void setConfiguration(double var1, double var3, double var5);

    public void setVelocity(double var1, double var3, double var5);

    public void setAcceleration(double var1, double var3, double var5);

    public void setEffort(double var1, double var3, double var5);

    default public void set(PlanarJointStateReadOnly other) {
        this.clear();
        if (other.hasOutputFor(JointStateType.CONFIGURATION)) {
            this.setConfiguration(other.getPitch(), other.getPositionX(), other.getPositionZ());
        }
        if (other.hasOutputFor(JointStateType.VELOCITY)) {
            this.setVelocity(other.getPitchVelocity(), other.getLinearVelocityX(), other.getLinearVelocityZ());
        }
        if (other.hasOutputFor(JointStateType.ACCELERATION)) {
            this.setAcceleration(other.getPitchAcceleration(), other.getLinearAccelerationX(), other.getLinearAccelerationZ());
        }
        if (other.hasOutputFor(JointStateType.EFFORT)) {
            this.setEffort(other.getTorqueY(), other.getForceX(), other.getForceZ());
        }
    }

    default public void setConfiguration(Pose3DReadOnly configuration) {
        this.setConfiguration((Orientation3DReadOnly)configuration.getOrientation(), (Tuple3DReadOnly)configuration.getPosition());
    }

    default public void setConfiguration(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        this.setConfiguration(orientation.getPitch(), position.getX(), position.getZ());
    }

    default public void setVelocity(SpatialVectorReadOnly velocity) {
        this.setVelocity((Vector3DReadOnly)velocity.getAngularPart(), (Vector3DReadOnly)velocity.getLinearPart());
    }

    default public void setVelocity(Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity) {
        this.setVelocity(angularVelocity.getY(), linearVelocity.getX(), linearVelocity.getZ());
    }

    default public void setAcceleration(SpatialVectorReadOnly acceleration) {
        this.setAcceleration((Vector3DReadOnly)acceleration.getAngularPart(), (Vector3DReadOnly)acceleration.getLinearPart());
    }

    default public void setAcceleration(Vector3DReadOnly angularAcceleration, Vector3DReadOnly linearAcceleration) {
        this.setAcceleration(angularAcceleration.getY(), linearAcceleration.getX(), linearAcceleration.getZ());
    }

    default public void setEffort(SpatialVectorReadOnly effort) {
        this.setEffort((Vector3DReadOnly)effort.getAngularPart(), (Vector3DReadOnly)effort.getLinearPart());
    }

    default public void setEffort(Vector3DReadOnly torque, Vector3DReadOnly force) {
        this.setEffort(torque.getY(), force.getX(), force.getZ());
    }

    @Override
    default public void setConfiguration(JointReadOnly joint) {
        this.setConfiguration(((PlanarJointReadOnly)joint).getJointPose());
    }

    @Override
    default public int setConfiguration(int startRow, DMatrix configuration) {
        this.setConfiguration(configuration.get(startRow++, 0), configuration.get(startRow++, 0), configuration.get(startRow++, 0));
        return startRow;
    }

    @Override
    default public void setVelocity(JointReadOnly joint) {
        this.setVelocity((SpatialVectorReadOnly)((PlanarJointReadOnly)joint).getJointTwist());
    }

    @Override
    default public int setVelocity(int startRow, DMatrix velocity) {
        this.setVelocity(velocity.get(startRow++, 0), velocity.get(startRow++, 0), velocity.get(startRow++, 0));
        return startRow;
    }

    @Override
    default public void setAcceleration(JointReadOnly joint) {
        this.setAcceleration((SpatialVectorReadOnly)((PlanarJointReadOnly)joint).getJointAcceleration());
    }

    @Override
    default public int setAcceleration(int startRow, DMatrix acceleration) {
        this.setAcceleration(acceleration.get(startRow++, 0), acceleration.get(startRow++, 0), acceleration.get(startRow++, 0));
        return startRow;
    }

    @Override
    default public void setEffort(JointReadOnly joint) {
        this.setEffort((SpatialVectorReadOnly)((PlanarJointReadOnly)joint).getJointWrench());
    }

    @Override
    default public int setEffort(int startRow, DMatrix effort) {
        this.setEffort(effort.get(startRow++, 0), effort.get(startRow++, 0), effort.get(startRow++, 0));
        return startRow;
    }
}

