/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;

public class LoopClosureDefinition {
    private YawPitchRollTransformDefinition transformToSuccessorParent = new YawPitchRollTransformDefinition();
    private Vector3D kpSoftConstraint;
    private Vector3D kdSoftConstraint;

    public LoopClosureDefinition() {
    }

    public LoopClosureDefinition(LoopClosureDefinition other) {
        this.transformToSuccessorParent.set((RigidBodyTransformReadOnly)other.transformToSuccessorParent);
        this.kpSoftConstraint = other.kpSoftConstraint == null ? null : new Vector3D((Tuple3DReadOnly)other.kpSoftConstraint);
        this.kdSoftConstraint = other.kdSoftConstraint == null ? null : new Vector3D((Tuple3DReadOnly)other.kdSoftConstraint);
    }

    public void setTransformToSuccessorParent(YawPitchRollTransformDefinition transformToSuccessorParent) {
        this.transformToSuccessorParent = transformToSuccessorParent;
    }

    public void setTransformToSuccessorParent(RigidBodyTransformReadOnly transformToSuccessorParent) {
        this.transformToSuccessorParent.set(transformToSuccessorParent);
    }

    public void setOffsetFromSuccessorParent(Tuple3DReadOnly offsetFromSuccessorParent) {
        this.transformToSuccessorParent.setTranslationAndIdentityRotation(offsetFromSuccessorParent);
    }

    public YawPitchRollTransformDefinition getTransformToSuccessorParent() {
        return this.transformToSuccessorParent;
    }

    public void setKpSoftConstraint(double kpSoftConstraint) {
        this.setKpSoftConstraint(new Vector3D(kpSoftConstraint, kpSoftConstraint, kpSoftConstraint));
    }

    public void setKpSoftConstraint(Vector3D kpSoftConstraint) {
        this.kpSoftConstraint = kpSoftConstraint;
    }

    public Vector3D getKpSoftConstraint() {
        return this.kpSoftConstraint;
    }

    public void setKdSoftConstraint(double kdSoftConstraint) {
        this.setKdSoftConstraint(new Vector3D(kdSoftConstraint, kdSoftConstraint, kdSoftConstraint));
    }

    public void setKdSoftConstraint(Vector3D kdSoftConstraint) {
        this.kdSoftConstraint = kdSoftConstraint;
    }

    public Vector3D getKdSoftConstraint() {
        return this.kdSoftConstraint;
    }

    public LoopClosureDefinition copy() {
        return new LoopClosureDefinition(this);
    }

    public String toString() {
        return "transformToSuccessorParent: " + this.transformToSuccessorParent;
    }

    public static Matrix3D jointForceSubSpace(JointDefinition joint) {
        if (joint instanceof RevoluteJointDefinition) {
            return LoopClosureDefinition.identityMatrix3D();
        }
        if (joint instanceof PrismaticJointDefinition) {
            return LoopClosureDefinition.matrix3DOrthogonalToVector3D((Vector3DReadOnly)((PrismaticJointDefinition)joint).getAxis());
        }
        return null;
    }

    public static Matrix3D jointMomentSubSpace(JointDefinition joint) {
        if (joint instanceof RevoluteJointDefinition) {
            return LoopClosureDefinition.matrix3DOrthogonalToVector3D((Vector3DReadOnly)((RevoluteJointDefinition)joint).getAxis());
        }
        if (joint instanceof PrismaticJointDefinition) {
            return LoopClosureDefinition.identityMatrix3D();
        }
        return null;
    }

    public static Matrix3D identityMatrix3D() {
        Matrix3D identity = new Matrix3D();
        identity.setIdentity();
        return identity;
    }

    public static Matrix3D matrix3DOrthogonalToVector3D(Vector3DReadOnly vector3D) {
        Matrix3D orthogonalMatrix = new Matrix3D();
        LoopClosureDefinition.matrix3DOrthogonalToVector3D(vector3D, (Matrix3DBasics)orthogonalMatrix);
        return orthogonalMatrix;
    }

    public static void matrix3DOrthogonalToVector3D(Vector3DReadOnly vector3D, Matrix3DBasics orthogonalMatrixToPack) {
        RotationMatrix R = new RotationMatrix();
        EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)vector3D, (Orientation3DBasics)R);
        orthogonalMatrixToPack.setIdentity();
        orthogonalMatrixToPack.setM22(0.0);
        R.transform(orthogonalMatrixToPack);
    }
}

