/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Tetrahedron3DDefinition
extends GeometryDefinition {
    private double edgeLength;

    public Tetrahedron3DDefinition() {
        this.setName("tetrahedron");
    }

    public Tetrahedron3DDefinition(double edgeLength) {
        this();
        this.edgeLength = edgeLength;
    }

    public Tetrahedron3DDefinition(Tetrahedron3DDefinition other) {
        this.setName(other.getName());
        this.edgeLength = other.edgeLength;
    }

    @XmlElement
    public void setEdgeLength(double edgeLength) {
        this.edgeLength = edgeLength;
    }

    public double getEdgeLength() {
        return this.edgeLength;
    }

    @Override
    public Tetrahedron3DDefinition copy() {
        return new Tetrahedron3DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.edgeLength);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Tetrahedron3DDefinition) {
            Tetrahedron3DDefinition other = (Tetrahedron3DDefinition)object;
            if (this.edgeLength != other.edgeLength) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "Tetrahedron: [name: " + this.getName() + ", edge length: " + this.edgeLength + "]";
    }
}

