/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Set;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;

public class SphericalJointState
extends JointStateBase
implements JointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private final Quaternion configuration = new Quaternion();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D torque = new Vector3D();

    public SphericalJointState() {
    }

    public SphericalJointState(SphericalJointState other) {
        this.configuration.set(other.configuration);
        this.angularVelocity.set(other.angularVelocity);
        this.angularAcceleration.set(other.angularAcceleration);
        this.torque.set(other.torque);
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    @Override
    public int getConfigurationSize() {
        return 4;
    }

    @Override
    public int getDegreesOfFreedom() {
        return 3;
    }

    @Override
    public void setConfiguration(JointReadOnly joint) {
        SphericalJointReadOnly sphericalJoint = (SphericalJointReadOnly)joint;
        this.configuration.set(sphericalJoint.getJointOrientation());
    }

    @Override
    public void setVelocity(JointReadOnly joint) {
        SphericalJointReadOnly sphericalJoint = (SphericalJointReadOnly)joint;
        this.angularVelocity.set((Tuple3DReadOnly)sphericalJoint.getJointAngularVelocity());
    }

    @Override
    public void setAcceleration(JointReadOnly joint) {
        SphericalJointReadOnly sphericalJoint = (SphericalJointReadOnly)joint;
        this.angularAcceleration.set((Tuple3DReadOnly)sphericalJoint.getJointAngularAcceleration());
    }

    @Override
    public void setEffort(JointReadOnly joint) {
        SphericalJointReadOnly sphericalJoint = (SphericalJointReadOnly)joint;
        this.torque.set((Tuple3DReadOnly)sphericalJoint.getJointTorque());
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    public Quaternion getConfiguration() {
        return this.configuration;
    }

    @Override
    public void getConfiguration(JointBasics jointToUpdate) {
        SphericalJointBasics sphericalJoint = (SphericalJointBasics)jointToUpdate;
        sphericalJoint.getJointOrientation().set((QuaternionReadOnly)this.configuration);
    }

    @Override
    public int getConfiguration(int startRow, DMatrix configurationToPack) {
        this.configuration.get(startRow, configurationToPack);
        return startRow + this.getConfigurationSize();
    }

    public Vector3D getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public void getVelocity(JointBasics jointToUpdate) {
        SphericalJointBasics sphericalJoint = (SphericalJointBasics)jointToUpdate;
        sphericalJoint.getJointAngularVelocity().set((Tuple3DReadOnly)this.angularVelocity);
    }

    @Override
    public int getVelocity(int startRow, DMatrix velocityToPack) {
        this.angularVelocity.get(startRow, velocityToPack);
        return startRow + this.getDegreesOfFreedom();
    }

    public Vector3D getAngularAcceleration() {
        return this.angularAcceleration;
    }

    @Override
    public void getAcceleration(JointBasics jointToUpdate) {
        SphericalJointBasics sphericalJoint = (SphericalJointBasics)jointToUpdate;
        sphericalJoint.getJointAngularAcceleration().set((Tuple3DReadOnly)this.angularAcceleration);
    }

    @Override
    public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        this.angularAcceleration.get(startRow, accelerationToPack);
        return startRow + this.getDegreesOfFreedom();
    }

    public Vector3D getTorque() {
        return this.torque;
    }

    @Override
    public void getEffort(JointBasics jointToUpdate) {
        SphericalJointBasics sphericalJoint = (SphericalJointBasics)jointToUpdate;
        sphericalJoint.getJointTorque().set((Tuple3DReadOnly)this.torque);
    }

    @Override
    public int getEffort(int startRow, DMatrix effortToPack) {
        this.torque.get(startRow, effortToPack);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public SphericalJointState copy() {
        return new SphericalJointState(this);
    }
}

