/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;

public class JointState
extends JointStateBase
implements JointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private final DMatrixRMaj configuration;
    private final DMatrixRMaj velocity;
    private final DMatrixRMaj acceleration;
    private final DMatrixRMaj effort;
    private final int configurationSize;
    private final int degreesOfFreedom;

    public JointState(int configurationSize, int degreesOfFreedom) {
        this.configurationSize = configurationSize;
        this.degreesOfFreedom = degreesOfFreedom;
        this.configuration = new DMatrixRMaj(configurationSize, 1);
        this.velocity = new DMatrixRMaj(degreesOfFreedom, 1);
        this.acceleration = new DMatrixRMaj(degreesOfFreedom, 1);
        this.effort = new DMatrixRMaj(degreesOfFreedom, 1);
    }

    public JointState(JointState other) {
        this.configurationSize = other.configurationSize;
        this.degreesOfFreedom = other.degreesOfFreedom;
        this.configuration = new DMatrixRMaj(other.configuration);
        this.velocity = new DMatrixRMaj(other.velocity);
        this.acceleration = new DMatrixRMaj(other.acceleration);
        this.effort = new DMatrixRMaj(other.effort);
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    @Override
    public int getConfigurationSize() {
        return this.configurationSize;
    }

    @Override
    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public void setConfiguration(JointReadOnly joint) {
        this.checkConfigurationSize(joint);
        this.availableStates.add(JointStateType.CONFIGURATION);
        joint.getJointConfiguration(0, (DMatrix)this.configuration);
    }

    @Override
    public void setVelocity(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.availableStates.add(JointStateType.VELOCITY);
        this.velocity.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointVelocity(0, (DMatrix)this.velocity);
    }

    @Override
    public void setAcceleration(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.availableStates.add(JointStateType.ACCELERATION);
        this.acceleration.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointAcceleration(0, (DMatrix)this.acceleration);
    }

    @Override
    public void setEffort(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.availableStates.add(JointStateType.EFFORT);
        this.effort.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointTau(0, (DMatrix)this.effort);
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public int getConfiguration(int startRow, DMatrix configurationToPack) {
        CommonOps_DDRM.insert((DMatrix)this.configuration, (DMatrix)configurationToPack, (int)startRow, (int)0);
        return startRow + this.configuration.getNumRows();
    }

    @Override
    public int getVelocity(int startRow, DMatrix velocityToPack) {
        CommonOps_DDRM.insert((DMatrix)this.velocity, (DMatrix)velocityToPack, (int)startRow, (int)0);
        return startRow + this.velocity.getNumRows();
    }

    @Override
    public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        CommonOps_DDRM.insert((DMatrix)this.acceleration, (DMatrix)accelerationToPack, (int)startRow, (int)0);
        return startRow + this.acceleration.getNumRows();
    }

    @Override
    public int getEffort(int startRow, DMatrix effortToPack) {
        CommonOps_DDRM.insert((DMatrix)this.effort, (DMatrix)effortToPack, (int)startRow, (int)0);
        return startRow + this.effort.getNumRows();
    }

    @Override
    public void getConfiguration(JointBasics jointToUpdate) {
        jointToUpdate.setJointConfiguration(0, (DMatrix)this.configuration);
    }

    @Override
    public void getVelocity(JointBasics jointToUpdate) {
        jointToUpdate.setJointVelocity(0, (DMatrix)this.velocity);
    }

    @Override
    public void getAcceleration(JointBasics jointToUpdate) {
        jointToUpdate.setJointAcceleration(0, (DMatrix)this.acceleration);
    }

    @Override
    public void getEffort(JointBasics jointToUpdate) {
        jointToUpdate.setJointTau(0, (DMatrix)this.effort);
    }

    public DMatrixRMaj getConfiguration() {
        return this.configuration;
    }

    public DMatrixRMaj getVelocity() {
        return this.velocity;
    }

    public DMatrixRMaj getAcceleration() {
        return this.acceleration;
    }

    public DMatrixRMaj getEffort() {
        return this.effort;
    }

    @Override
    public JointState copy() {
        return new JointState(this);
    }
}

