/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.sdf;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.AffineTransformDefinition;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.FixedJointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.LidarSensorDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.PlanarJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.robot.sdf.items.SDFGeometry;
import us.ihmc.scs2.definition.robot.sdf.items.SDFInertia;
import us.ihmc.scs2.definition.robot.sdf.items.SDFJoint;
import us.ihmc.scs2.definition.robot.sdf.items.SDFLink;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.definition.robot.sdf.items.SDFSensor;
import us.ihmc.scs2.definition.robot.sdf.items.SDFURIHolder;
import us.ihmc.scs2.definition.robot.sdf.items.SDFVisual;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class SDFTools {
    private static final double DEFAULT_MASS = 0.0;
    private static final double DEFAULT_IXX = 0.0;
    private static final double DEFAULT_IYY = 0.0;
    private static final double DEFAULT_IZZ = 0.0;
    private static final double DEFAULT_IXY = 0.0;
    private static final double DEFAULT_IXZ = 0.0;
    private static final double DEFAULT_IYZ = 0.0;
    private static final Vector3DReadOnly DEFAULT_AXIS = new Vector3D(1.0, 0.0, 0.0);
    private static final double DEFAULT_LOWER_LIMIT = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_UPPER_LIMIT = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_EFFORT_LIMIT = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_VELOCITY_LIMIT = Double.POSITIVE_INFINITY;

    public static SDFRoot loadSDFRoot(File sdfFile) throws JAXBException {
        return SDFTools.loadSDFRoot(sdfFile, Collections.emptyList());
    }

    public static SDFRoot loadSDFRoot(File sdfFile, Collection<String> resourceDirectories) throws JAXBException {
        HashSet<String> allResourceDirectories = new HashSet<String>(resourceDirectories);
        File parentFile = sdfFile.getParentFile();
        if (parentFile != null) {
            allResourceDirectories.add(parentFile.getAbsolutePath() + File.separator);
            Stream.of(parentFile.listFiles(File::isDirectory)).map(file -> file.getAbsolutePath() + File.separator).forEach(allResourceDirectories::add);
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SDFRoot.class});
        Unmarshaller um = context.createUnmarshaller();
        SDFRoot sdfRoot = (SDFRoot)um.unmarshal(sdfFile);
        SDFTools.resolvePaths(sdfRoot, allResourceDirectories);
        return sdfRoot;
    }

    public static SDFRoot loadSDFRoot(InputStream inputStream, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SDFRoot.class});
        Unmarshaller um = context.createUnmarshaller();
        SDFRoot sdfRoot = (SDFRoot)um.unmarshal(inputStream);
        SDFTools.resolvePaths(sdfRoot, resourceDirectories, resourceClassLoader);
        return sdfRoot;
    }

    public static void resolvePaths(SDFRoot sdfRoot, Collection<String> resourceDirectories) {
        SDFTools.resolvePaths(sdfRoot, resourceDirectories, null);
    }

    public static void resolvePaths(SDFRoot sdfRoot, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) {
        if (resourceClassLoader == null) {
            resourceClassLoader = SDFTools.class.getClassLoader();
        }
        List<SDFURIHolder> uriHolders = sdfRoot.getURIHolders();
        for (SDFURIHolder sdfURIHolder : uriHolders) {
            sdfURIHolder.setUri(SDFTools.tryToConvertToPath(sdfURIHolder.getUri(), resourceDirectories, resourceClassLoader));
        }
    }

    public static String tryToConvertToPath(String filename, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) {
        try {
            int n;
            String newResource;
            URI uri = new URI(filename);
            String authority = uri.getAuthority() == null ? "" : uri.getAuthority();
            for (String string : resourceDirectories) {
                String fullname = string + authority + uri.getPath();
                if (resourceClassLoader.getResource(fullname) != null) {
                    return fullname;
                }
                if (!new File(fullname).exists()) continue;
                return fullname;
            }
            String resourceContainingAuthority = null;
            for (String resourceDirectory : resourceDirectories) {
                if (!resourceDirectory.contains(authority)) continue;
                resourceContainingAuthority = resourceDirectory;
                break;
            }
            if (resourceContainingAuthority != null && !resourceDirectories.contains(newResource = resourceContainingAuthority.substring(0, n = resourceContainingAuthority.lastIndexOf(authority, resourceContainingAuthority.length())))) {
                resourceDirectories.add(newResource);
                return SDFTools.tryToConvertToPath(filename, resourceDirectories, resourceClassLoader);
            }
        }
        catch (URISyntaxException e) {
            System.err.println("Malformed resource path in SDF file for path: " + filename);
        }
        return null;
    }

    public static RobotDefinition toFloatingRobotDefinition(SDFModel sdfModel) {
        return SDFTools.toRobotDefinition(new SixDoFJointDefinition(), sdfModel);
    }

    public static RobotDefinition toRobotDefinition(JointDefinition rootJointDefinition, SDFModel sdfModel) {
        List<SDFLink> sdfLinks = sdfModel.getLinks();
        List<SDFJoint> sdfJoints = sdfModel.getJoints();
        List<RigidBodyDefinition> rigidBodyDefinitions = sdfLinks.stream().map(SDFTools::toRigidBodyDefinition).collect(Collectors.toList());
        List<JointDefinition> jointDefinitions = sdfJoints == null ? Collections.emptyList() : sdfJoints.stream().map(SDFTools::toJointDefinition).collect(Collectors.toList());
        RigidBodyDefinition startBodyDefinition = SDFTools.connectKinematics(rigidBodyDefinitions, jointDefinitions, sdfJoints, sdfLinks);
        if (rootJointDefinition.getName() == null) {
            rootJointDefinition.setName(startBodyDefinition.getName());
        }
        rootJointDefinition.setSuccessor(startBodyDefinition);
        RigidBodyDefinition rootBodyDefinition = new RigidBodyDefinition("rootBody");
        rootBodyDefinition.addChildJoint(rootJointDefinition);
        SDFTools.addSensors(sdfLinks, rigidBodyDefinitions);
        SDFTools.correctTransforms(sdfJoints, sdfLinks, jointDefinitions);
        RobotDefinition robotDefinition = new RobotDefinition(sdfModel.getName());
        robotDefinition.setRootBodyDefinition(rootBodyDefinition);
        return robotDefinition;
    }

    public static RigidBodyDefinition connectKinematics(List<RigidBodyDefinition> rigidBodyDefinitions, List<JointDefinition> jointDefinitions, List<SDFJoint> sdfJoints, List<SDFLink> sdfLinks) {
        if (sdfJoints == null) {
            return rigidBodyDefinitions.get(0);
        }
        Map rigidBodyDefinitionMap = rigidBodyDefinitions.stream().collect(Collectors.toMap(RigidBodyDefinition::getName, Function.identity()));
        Map jointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(JointDefinition::getName, Function.identity()));
        for (SDFJoint sdfJoint : sdfJoints) {
            String parent = sdfJoint.getParent();
            String child = sdfJoint.getChild();
            RigidBodyDefinition parentRigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(parent);
            RigidBodyDefinition childRigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(child);
            JointDefinition jointDefinition = (JointDefinition)jointDefinitionMap.get(sdfJoint.getName());
            jointDefinition.setSuccessor(childRigidBodyDefinition);
            parentRigidBodyDefinition.addChildJoint(jointDefinition);
        }
        RigidBodyDefinition rootBody = jointDefinitions.get(0).getPredecessor();
        while (rootBody.getParentJoint() != null) {
            rootBody = rootBody.getParentJoint().getPredecessor();
        }
        return rootBody;
    }

    public static void addSensors(List<SDFLink> sdfLinks, List<RigidBodyDefinition> rigidBodyDefinitions) {
        Map rigidBodyDefinitionMap = rigidBodyDefinitions.stream().collect(Collectors.toMap(RigidBodyDefinition::getName, Function.identity()));
        for (SDFLink sdfLink : sdfLinks) {
            if (sdfLink.getSensors() == null) continue;
            RigidBodyDefinition rigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(sdfLink.getName());
            JointDefinition parentJoint = rigidBodyDefinition.getParentJoint();
            for (SDFSensor sdfSensor : sdfLink.getSensors()) {
                List<SensorDefinition> sensorDefinitions = SDFTools.toSensorDefinition(sdfSensor);
                if (sensorDefinitions == null) continue;
                sensorDefinitions.forEach(parentJoint::addSensorDefinition);
            }
        }
    }

    public static void correctTransforms(List<SDFJoint> sdfJoints, List<SDFLink> sdfLinks, List<JointDefinition> jointDefinitions) {
        Map sdfLinkMap = sdfLinks.stream().collect(Collectors.toMap(SDFLink::getName, Function.identity()));
        Map jointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(JointDefinition::getName, Function.identity()));
        for (SDFJoint sdfJoint : sdfJoints) {
            String jointName = sdfJoint.getName();
            JointDefinition jointDefinition = (JointDefinition)jointDefinitionMap.get(jointName);
            RigidBodyDefinition childDefinition = jointDefinition.getSuccessor();
            String parentLinkName = sdfJoint.getParent();
            String childLinkName = sdfJoint.getChild();
            SDFLink parentSDFLink = (SDFLink)sdfLinkMap.get(parentLinkName);
            SDFLink childSDFLink = (SDFLink)sdfLinkMap.get(childLinkName);
            RigidBodyTransform parentLinkPose = SDFTools.parsePose(parentSDFLink.getPose());
            RigidBodyTransform childLinkPose = SDFTools.parsePose(childSDFLink.getPose());
            YawPitchRollTransformDefinition transformToParentJoint = jointDefinition.getTransformToParent();
            transformToParentJoint.setAndInvert((RigidBodyTransformReadOnly)parentLinkPose);
            transformToParentJoint.multiply((RigidBodyTransformReadOnly)childLinkPose);
            transformToParentJoint.getRotation().setToZero();
            parentLinkPose.transform((Vector3DBasics)transformToParentJoint.getTranslation());
            YawPitchRollTransformDefinition inertiaPose = childDefinition.getInertiaPose();
            inertiaPose.prependOrientation((Orientation3DReadOnly)childLinkPose.getRotation());
            inertiaPose.transform(childDefinition.getMomentOfInertia());
            inertiaPose.getRotation().setToZero();
            for (VisualDefinition visualDescription : childDefinition.getVisualDefinitions()) {
                AffineTransformDefinition visualPose = visualDescription.getOriginPose();
                visualPose.prependOrientation((Orientation3DReadOnly)childLinkPose.getRotation());
            }
            for (SensorDefinition sensorDefinition : jointDefinition.getSensorDefinitions()) {
                sensorDefinition.getTransformToJoint().prependOrientation((Orientation3DReadOnly)childLinkPose.getRotation());
            }
        }
    }

    public static RigidBodyDefinition toRigidBodyDefinition(SDFLink sdfLink) {
        RigidBodyDefinition definition = new RigidBodyDefinition(sdfLink.getName());
        SDFLink.SDFInertial sdfInertial = sdfLink.getInertial();
        if (sdfInertial == null) {
            definition.setMass(SDFTools.parseDouble(null, 0.0));
            definition.getMomentOfInertia().set((Matrix3DReadOnly)SDFTools.parseMomentOfInertia(null));
            definition.getInertiaPose().set((RigidBodyTransformReadOnly)SDFTools.parsePose(null));
        } else {
            definition.setMass(SDFTools.parseDouble(sdfInertial.getMass(), 0.0));
            definition.getMomentOfInertia().set((Matrix3DReadOnly)SDFTools.parseMomentOfInertia(sdfInertial.getInertia()));
            definition.getInertiaPose().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfInertial.getPose()));
        }
        if (sdfLink.getVisuals() != null) {
            sdfLink.getVisuals().stream().map(SDFTools::toVisualDefinition).forEach(definition::addVisualDefinition);
        }
        return definition;
    }

    public static JointDefinition toJointDefinition(SDFJoint sdfJoint) {
        switch (sdfJoint.getType()) {
            case "continuous": {
                return SDFTools.toRevoluteJointDefinition(sdfJoint, true);
            }
            case "revolute": {
                return SDFTools.toRevoluteJointDefinition(sdfJoint, false);
            }
            case "prismatic": {
                return SDFTools.toPrismaticJointDefinition(sdfJoint);
            }
            case "fixed": {
                return SDFTools.toFixedJoint(sdfJoint);
            }
            case "floating": {
                return SDFTools.toSixDoFJointDefinition(sdfJoint);
            }
            case "planar": {
                return SDFTools.toPlanarJointDefinition(sdfJoint);
            }
        }
        throw new RuntimeException("Unexpected value for the joint type: " + sdfJoint.getType());
    }

    public static RevoluteJointDefinition toRevoluteJointDefinition(SDFJoint sdfJoint, boolean ignorePositionLimits) {
        RevoluteJointDefinition definition = new RevoluteJointDefinition(sdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfJoint.getPose()));
        definition.getAxis().set(SDFTools.parseAxis(sdfJoint.getAxis()));
        SDFTools.parseLimit(sdfJoint.getAxis().getLimit(), definition, ignorePositionLimits);
        SDFTools.parseDynamics(sdfJoint.getAxis().getDynamics(), definition);
        return definition;
    }

    public static PrismaticJointDefinition toPrismaticJointDefinition(SDFJoint sdfJoint) {
        PrismaticJointDefinition definition = new PrismaticJointDefinition(sdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfJoint.getPose()));
        definition.getAxis().set(SDFTools.parseAxis(sdfJoint.getAxis()));
        SDFTools.parseLimit(sdfJoint.getAxis().getLimit(), definition, false);
        SDFTools.parseDynamics(sdfJoint.getAxis().getDynamics(), definition);
        return definition;
    }

    public static FixedJointDefinition toFixedJoint(SDFJoint sdfJoint) {
        FixedJointDefinition definition = new FixedJointDefinition(sdfJoint.getName());
        RigidBodyTransform parseRigidBodyTransform = SDFTools.parsePose(sdfJoint.getPose());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)parseRigidBodyTransform);
        return definition;
    }

    public static SixDoFJointDefinition toSixDoFJointDefinition(SDFJoint sdfJoint) {
        SixDoFJointDefinition definition = new SixDoFJointDefinition(sdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfJoint.getPose()));
        return definition;
    }

    public static PlanarJointDefinition toPlanarJointDefinition(SDFJoint sdfJoint) {
        PlanarJointDefinition definition = new PlanarJointDefinition(sdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfJoint.getPose()));
        Vector3D surfaceNormal = SDFTools.parseAxis(sdfJoint.getAxis());
        if (!surfaceNormal.geometricallyEquals((Vector3DReadOnly)Axis3D.Y, 1.0E-5)) {
            throw new UnsupportedOperationException("Planar joint are supported only with a surface normal equal to: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)Axis3D.Y) + ", received:" + surfaceNormal);
        }
        return definition;
    }

    public static List<SensorDefinition> toSensorDefinition(SDFSensor sdfSensor) {
        ArrayList<SensorDefinition> definitions = new ArrayList<SensorDefinition>();
        switch (sdfSensor.getType()) {
            case "camera": 
            case "multicamera": 
            case "depth": {
                definitions.addAll(SDFTools.toCameraSensorDefinition(sdfSensor.getCamera()));
                break;
            }
            case "imu": {
                definitions.add(SDFTools.toIMUSensorDefinition(sdfSensor.getImu()));
                break;
            }
            case "gpu_ray": 
            case "ray": {
                definitions.add(SDFTools.toLidarSensorDefinition(sdfSensor.getRay()));
                break;
            }
            default: {
                LogTools.error((String)("Unsupport sensor type: " + sdfSensor.getType()));
                return null;
            }
        }
        int updatePeriod = sdfSensor.getUpdateRate() == null ? -1 : (int)(1000.0 / SDFTools.parseDouble(sdfSensor.getUpdateRate(), 1000.0));
        for (SensorDefinition definition : definitions) {
            if (definition.getName() != null && !definition.getName().isEmpty()) {
                definition.setName(sdfSensor.getName() + "_" + definition.getName());
            } else {
                definition.setName(sdfSensor.getName());
            }
            definition.getTransformToJoint().preMultiply((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfSensor.getPose()));
            definition.setUpdatePeriod(updatePeriod);
        }
        return definitions;
    }

    public static List<CameraSensorDefinition> toCameraSensorDefinition(List<SDFSensor.SDFCamera> sdfCameras) {
        return sdfCameras.stream().map(SDFTools::toCameraSensorDefinition).collect(Collectors.toList());
    }

    public static CameraSensorDefinition toCameraSensorDefinition(SDFSensor.SDFCamera sdfCamera) {
        CameraSensorDefinition definition = new CameraSensorDefinition();
        definition.setName(sdfCamera.getName());
        definition.getTransformToJoint().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfCamera.getPose()));
        definition.setFieldOfView(SDFTools.parseDouble(sdfCamera.getHorizontalFov(), Double.NaN));
        definition.setClipNear(SDFTools.parseDouble(sdfCamera.getClip().getNear(), Double.NaN));
        definition.setClipFar(SDFTools.parseDouble(sdfCamera.getClip().getFar(), Double.NaN));
        definition.setImageWidth(SDFTools.parseInteger(sdfCamera.getImage().getWidth(), -1));
        definition.setImageHeight(SDFTools.parseInteger(sdfCamera.getImage().getHeight(), -1));
        return definition;
    }

    public static LidarSensorDefinition toLidarSensorDefinition(SDFSensor.SDFRay sdfRay) {
        LidarSensorDefinition definition = new LidarSensorDefinition();
        SDFSensor.SDFRay.SDFRange sdfRange = sdfRay.getRange();
        double sdfRangeMax = SDFTools.parseDouble(sdfRange.getMax(), Double.NaN);
        double sdfRangeMin = SDFTools.parseDouble(sdfRange.getMin(), Double.NaN);
        double sdfRangeResolution = SDFTools.parseDouble(sdfRange.getResolution(), Double.NaN);
        SDFSensor.SDFRay.SDFScan.SDFHorizontalScan sdfHorizontalScan = sdfRay.getScan().getHorizontal();
        SDFSensor.SDFRay.SDFScan.SDFVerticalScan sdfVerticalScan = sdfRay.getScan().getVertical();
        double maxSweepAngle = SDFTools.parseDouble(sdfHorizontalScan.getMaxAngle(), 0.0);
        double minSweepAngle = SDFTools.parseDouble(sdfHorizontalScan.getMinAngle(), 0.0);
        double maxHeightAngle = sdfVerticalScan == null ? 0.0 : SDFTools.parseDouble(sdfVerticalScan.getMaxAngle(), 0.0);
        double minHeightAngle = sdfVerticalScan == null ? 0.0 : SDFTools.parseDouble(sdfVerticalScan.getMinAngle(), 0.0);
        int samples = SDFTools.parseInteger(sdfHorizontalScan.getSamples(), -1) / 3 * 3;
        int scanHeight = sdfVerticalScan == null ? 1 : SDFTools.parseInteger(sdfVerticalScan.getSamples(), 1);
        SDFSensor.SDFRay.SDFNoise sdfNoise = sdfRay.getNoise();
        if (sdfNoise != null) {
            if ("gaussian".equals(sdfNoise.getType())) {
                definition.setGaussianNoiseMean(SDFTools.parseDouble(sdfNoise.getMean(), 0.0));
                definition.setGaussianNoiseStandardDeviation(SDFTools.parseDouble(sdfNoise.getStddev(), 0.0));
            } else {
                LogTools.error((String)"Unknown noise model: {}.", (Object)sdfNoise.getType());
            }
        }
        definition.getTransformToJoint().set((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfRay.getPose()));
        definition.setPointsPerSweep(samples);
        definition.setSweepYawLimits(minSweepAngle, maxSweepAngle);
        definition.setHeightPitchLimits(minHeightAngle, maxHeightAngle);
        definition.setRangeLimits(sdfRangeMin, sdfRangeMax);
        definition.setRangeResolution(sdfRangeResolution);
        definition.setScanHeight(scanHeight);
        return definition;
    }

    public static IMUSensorDefinition toIMUSensorDefinition(SDFSensor.SDFIMU sdfIMU) {
        IMUSensorDefinition definition = new IMUSensorDefinition();
        SDFSensor.SDFIMU.SDFIMUNoise sdfNoise = sdfIMU.getNoise();
        if (sdfNoise != null) {
            if ("gaussian".equals(sdfNoise.getType())) {
                SDFSensor.SDFIMU.SDFIMUNoise.SDFNoiseParameters accelerationNoise = sdfNoise.getAccel();
                SDFSensor.SDFIMU.SDFIMUNoise.SDFNoiseParameters angularVelocityNoise = sdfNoise.getRate();
                definition.setAccelerationNoiseParameters(SDFTools.parseDouble(accelerationNoise.getMean(), 0.0), SDFTools.parseDouble(accelerationNoise.getStddev(), 0.0));
                definition.setAccelerationBiasParameters(SDFTools.parseDouble(accelerationNoise.getBias_mean(), 0.0), SDFTools.parseDouble(accelerationNoise.getBias_stddev(), 0.0));
                definition.setAngularVelocityNoiseParameters(SDFTools.parseDouble(angularVelocityNoise.getMean(), 0.0), SDFTools.parseDouble(angularVelocityNoise.getStddev(), 0.0));
                definition.setAngularVelocityBiasParameters(SDFTools.parseDouble(angularVelocityNoise.getBias_mean(), 0.0), SDFTools.parseDouble(angularVelocityNoise.getBias_stddev(), 0.0));
            } else {
                LogTools.error((String)"Unknown IMU noise model: {}.", (Object)sdfNoise.getType());
            }
        }
        return definition;
    }

    public static VisualDefinition toVisualDefinition(SDFVisual sdfVisual) {
        if (sdfVisual == null) {
            return null;
        }
        VisualDefinition visualDefinition = new VisualDefinition();
        visualDefinition.setName(sdfVisual.getName());
        visualDefinition.setOriginPose((RigidBodyTransformReadOnly)SDFTools.parsePose(sdfVisual.getPose()));
        visualDefinition.setMaterialDefinition(SDFTools.toMaterialDefinition(sdfVisual.getMaterial()));
        visualDefinition.setGeometryDefinition(SDFTools.toGeometryDefinition(sdfVisual.getGeometry()));
        return visualDefinition;
    }

    public static GeometryDefinition toGeometryDefinition(SDFGeometry sdfGeometry) {
        return SDFTools.toGeometryDefinition(sdfGeometry, Collections.emptyList());
    }

    public static GeometryDefinition toGeometryDefinition(SDFGeometry sdfGeometry, List<String> resourceDirectories) {
        if (sdfGeometry.getBox() != null) {
            Box3DDefinition boxGeometryDefinition = new Box3DDefinition();
            boxGeometryDefinition.setSize((Tuple3DReadOnly)SDFTools.parseVector3D(sdfGeometry.getBox().getSize(), null));
            return boxGeometryDefinition;
        }
        if (sdfGeometry.getCylinder() != null) {
            Cylinder3DDefinition cylinderGeometryDefinition = new Cylinder3DDefinition();
            cylinderGeometryDefinition.setRadius(SDFTools.parseDouble(sdfGeometry.getCylinder().getRadius(), 0.0));
            cylinderGeometryDefinition.setLength(SDFTools.parseDouble(sdfGeometry.getCylinder().getLength(), 0.0));
            return cylinderGeometryDefinition;
        }
        if (sdfGeometry.getSphere() != null) {
            Sphere3DDefinition sphereGeometryDefinition = new Sphere3DDefinition();
            sphereGeometryDefinition.setRadius(SDFTools.parseDouble(sdfGeometry.getSphere().getRadius(), 0.0));
            return sphereGeometryDefinition;
        }
        if (sdfGeometry.getMesh() != null) {
            ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition();
            modelFileGeometryDefinition.setResourceDirectories(resourceDirectories);
            modelFileGeometryDefinition.setFileName(sdfGeometry.getMesh().getUri());
            modelFileGeometryDefinition.setScale(SDFTools.parseVector3D(sdfGeometry.getMesh().getScale(), new Vector3D(1.0, 1.0, 1.0)));
            return modelFileGeometryDefinition;
        }
        throw new IllegalArgumentException("The given SDF Geometry is empty.");
    }

    public static MaterialDefinition toMaterialDefinition(SDFVisual.SDFMaterial sdfMaterial) {
        if (sdfMaterial == null) {
            return null;
        }
        MaterialDefinition materialDefinition = new MaterialDefinition();
        materialDefinition.setShininess(SDFTools.parseDouble(sdfMaterial.getLighting(), Double.NaN));
        materialDefinition.setAmbientColor(SDFTools.toColorDefinition(sdfMaterial.getAmbient()));
        materialDefinition.setDiffuseColor(SDFTools.toColorDefinition(sdfMaterial.getDiffuse()));
        materialDefinition.setSpecularColor(SDFTools.toColorDefinition(sdfMaterial.getSpecular()));
        materialDefinition.setEmissiveColor(SDFTools.toColorDefinition(sdfMaterial.getEmissive()));
        return materialDefinition;
    }

    public static ColorDefinition toColorDefinition(String sdfColor) {
        if (sdfColor == null) {
            return null;
        }
        double[] colorArray = SDFTools.parseArray(sdfColor, null);
        if (colorArray == null) {
            return null;
        }
        if (colorArray.length < 4) {
            return ColorDefinitions.rgb(colorArray);
        }
        return ColorDefinitions.rgba(colorArray);
    }

    public static RigidBodyTransform parsePose(String pose) {
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        if (pose != null) {
            String[] split = pose.split("\\s+");
            Vector3D position = new Vector3D(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
            YawPitchRoll orientation = new YawPitchRoll(Double.parseDouble(split[5]), Double.parseDouble(split[4]), Double.parseDouble(split[3]));
            rigidBodyTransform.set((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
        }
        return rigidBodyTransform;
    }

    public static Matrix3D parseMomentOfInertia(SDFInertia inertia) {
        if (inertia == null) {
            inertia = new SDFInertia();
        }
        Matrix3D momentOfInertia = new Matrix3D();
        double ixx = SDFTools.parseDouble(inertia.getIxx(), 0.0);
        double iyy = SDFTools.parseDouble(inertia.getIyy(), 0.0);
        double izz = SDFTools.parseDouble(inertia.getIzz(), 0.0);
        double ixy = SDFTools.parseDouble(inertia.getIxy(), 0.0);
        double ixz = SDFTools.parseDouble(inertia.getIxz(), 0.0);
        double iyz = SDFTools.parseDouble(inertia.getIyz(), 0.0);
        momentOfInertia.setM00(ixx);
        momentOfInertia.setM11(iyy);
        momentOfInertia.setM22(izz);
        momentOfInertia.setM01(ixy);
        momentOfInertia.setM02(ixz);
        momentOfInertia.setM12(iyz);
        momentOfInertia.setM10(ixy);
        momentOfInertia.setM20(ixz);
        momentOfInertia.setM21(iyz);
        return momentOfInertia;
    }

    public static void parseLimit(SDFJoint.SDFAxis.SDFLimit sdfLimit, OneDoFJointDefinition jointDefinitionToParseLimitInto, boolean ignorePositionLimits) {
        jointDefinitionToParseLimitInto.setPositionLimits(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        jointDefinitionToParseLimitInto.setEffortLimits(Double.POSITIVE_INFINITY);
        jointDefinitionToParseLimitInto.setVelocityLimits(Double.POSITIVE_INFINITY);
        if (sdfLimit != null) {
            double velocityLimit;
            double effortLimit;
            double positionUpperLimit;
            double positionLowerLimit;
            if (!ignorePositionLimits && (positionLowerLimit = SDFTools.parseDouble(sdfLimit.getLower(), Double.NEGATIVE_INFINITY)) < (positionUpperLimit = SDFTools.parseDouble(sdfLimit.getUpper(), Double.POSITIVE_INFINITY))) {
                jointDefinitionToParseLimitInto.setPositionLimits(positionLowerLimit, positionUpperLimit);
            }
            if (Double.isFinite(effortLimit = SDFTools.parseDouble(sdfLimit.getEffort(), Double.POSITIVE_INFINITY)) && effortLimit >= 0.0) {
                jointDefinitionToParseLimitInto.setEffortLimits(effortLimit);
            }
            if (Double.isFinite(velocityLimit = SDFTools.parseDouble(sdfLimit.getVelocity(), Double.POSITIVE_INFINITY)) && velocityLimit >= 0.0) {
                jointDefinitionToParseLimitInto.setVelocityLimits(velocityLimit);
            }
        }
    }

    public static void parseDynamics(SDFJoint.SDFAxis.SDFDynamics sdfDynamics, OneDoFJointDefinition jointDefinitionToParseDynamicsInto) {
        double damping = 0.0;
        double stiction = 0.0;
        if (sdfDynamics != null) {
            damping = SDFTools.parseDouble(sdfDynamics.getDamping(), 0.0);
            stiction = SDFTools.parseDouble(sdfDynamics.getFriction(), 0.0);
        }
        jointDefinitionToParseDynamicsInto.setDamping(damping);
        jointDefinitionToParseDynamicsInto.setStiction(stiction);
    }

    public static Vector3D parseAxis(SDFJoint.SDFAxis axis) {
        if (axis == null) {
            return new Vector3D((Tuple3DReadOnly)DEFAULT_AXIS);
        }
        Vector3D parsedAxis = SDFTools.parseVector3D(axis.getXYZ(), new Vector3D((Tuple3DReadOnly)DEFAULT_AXIS));
        parsedAxis.normalize();
        return parsedAxis;
    }

    public static double parseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static int parseInteger(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Vector3D parseVector3D(String value, Vector3D defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String[] split = value.split("\\s+");
        Vector3D vector = new Vector3D();
        vector.setX(Double.parseDouble(split[0]));
        vector.setY(Double.parseDouble(split[1]));
        vector.setZ(Double.parseDouble(split[2]));
        return vector;
    }

    public static double[] parseArray(String value, double[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String[] split = value.split("\\s+");
        double[] array = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            array[i] = Double.parseDouble(split[i]);
        }
        return array;
    }
}

