/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public interface SixDoFJointStateReadOnly
extends JointStateReadOnly {
    public Pose3DReadOnly getConfiguration();

    public Vector3DReadOnly getAngularVelocity();

    public Vector3DReadOnly getLinearVelocity();

    public Vector3DReadOnly getAngularAcceleration();

    public Vector3DReadOnly getLinearAcceleration();

    public Vector3DReadOnly getTorque();

    public Vector3DReadOnly getForce();

    @Override
    default public int getConfigurationSize() {
        return 7;
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 6;
    }

    @Override
    default public int getConfiguration(int startRow, DMatrix configurationToPack) {
        this.getConfiguration().getOrientation().get(startRow, configurationToPack);
        this.getConfiguration().getPosition().get(startRow += 4, configurationToPack);
        return startRow + 3;
    }

    @Override
    default public int getVelocity(int startRow, DMatrix velocityToPack) {
        this.getAngularVelocity().get(startRow, velocityToPack);
        this.getLinearVelocity().get(startRow += 3, velocityToPack);
        return startRow + 3;
    }

    @Override
    default public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        this.getAngularAcceleration().get(startRow, accelerationToPack);
        this.getLinearAcceleration().get(startRow += 3, accelerationToPack);
        return startRow + 3;
    }

    @Override
    default public int getEffort(int startRow, DMatrix effortToPack) {
        this.getTorque().get(startRow, effortToPack);
        this.getForce().get(startRow += 3, effortToPack);
        return startRow + 3;
    }

    @Override
    default public void getConfiguration(JointBasics jointToUpdate) {
        ((SixDoFJointBasics)jointToUpdate).setJointConfiguration(this.getConfiguration());
    }

    @Override
    default public void getVelocity(JointBasics jointToUpdate) {
        ((SixDoFJointBasics)jointToUpdate).getJointTwist().set(this.getAngularVelocity(), this.getLinearVelocity());
    }

    @Override
    default public void getAcceleration(JointBasics jointToUpdate) {
        ((SixDoFJointBasics)jointToUpdate).getJointAcceleration().set(this.getAngularAcceleration(), this.getLinearAcceleration());
    }

    @Override
    default public void getEffort(JointBasics jointToUpdate) {
        ((SixDoFJointBasics)jointToUpdate).getJointWrench().set(this.getTorque(), this.getForce());
    }
}

