/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Set;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;

public class OneDoFJointState
extends JointStateBase
implements OneDoFJointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private double configuration = 0.0;
    private double velocity = 0.0;
    private double acceleration = 0.0;
    private double effort = 0.0;

    public OneDoFJointState() {
    }

    public OneDoFJointState(double q) {
        this.setConfiguration(q);
    }

    public OneDoFJointState(double q, double qd) {
        this.setConfiguration(q);
        this.setVelocity(qd);
    }

    public OneDoFJointState(double q, double qd, double tau) {
        this.setConfiguration(q);
        this.setVelocity(qd);
        this.setEffort(tau);
    }

    public OneDoFJointState(OneDoFJointState other) {
        this.configuration = other.configuration;
        this.velocity = other.velocity;
        this.acceleration = other.acceleration;
        this.effort = other.effort;
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    @Override
    public void setConfiguration(double q) {
        this.availableStates.add(JointStateType.CONFIGURATION);
        this.configuration = q;
    }

    @Override
    public void setVelocity(double qd) {
        this.availableStates.add(JointStateType.VELOCITY);
        this.velocity = qd;
    }

    @Override
    public void setAcceleration(double qdd) {
        this.availableStates.add(JointStateType.ACCELERATION);
        this.acceleration = qdd;
    }

    @Override
    public void setEffort(double tau) {
        this.availableStates.add(JointStateType.EFFORT);
        this.effort = tau;
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public double getConfiguration() {
        return this.configuration;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    @Override
    public double getAcceleration() {
        return this.acceleration;
    }

    @Override
    public double getEffort() {
        return this.effort;
    }

    @Override
    public OneDoFJointState copy() {
        return new OneDoFJointState(this);
    }
}

