/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.robot.JointDefinition;

public abstract class OneDoFJointDefinition
extends JointDefinition {
    private Vector3D axis = new Vector3D();
    private double positionLowerLimit = Double.NEGATIVE_INFINITY;
    private double positionUpperLimit = Double.POSITIVE_INFINITY;
    private double velocityLowerLimit = Double.NEGATIVE_INFINITY;
    private double velocityUpperLimit = Double.POSITIVE_INFINITY;
    private double effortLowerLimit = Double.NEGATIVE_INFINITY;
    private double effortUpperLimit = Double.POSITIVE_INFINITY;
    private double damping = -1.0;
    private double stiction = -1.0;
    private double kpSoftLimitStop = -1.0;
    private double kdSoftLimitStop = -1.0;

    public OneDoFJointDefinition() {
    }

    public OneDoFJointDefinition(String name) {
        super(name);
    }

    public OneDoFJointDefinition(String name, Tuple3DReadOnly offsetFromParent, Vector3DReadOnly axis) {
        super(name, offsetFromParent);
        this.setAxis(axis);
    }

    public OneDoFJointDefinition(OneDoFJointDefinition other) {
        super(other);
        this.axis.set(other.axis);
        this.positionLowerLimit = other.positionLowerLimit;
        this.positionUpperLimit = other.positionUpperLimit;
        this.velocityLowerLimit = other.velocityLowerLimit;
        this.velocityUpperLimit = other.velocityUpperLimit;
        this.effortLowerLimit = other.effortLowerLimit;
        this.effortUpperLimit = other.effortUpperLimit;
        this.damping = other.damping;
        this.stiction = other.stiction;
        this.kpSoftLimitStop = other.kpSoftLimitStop;
        this.kdSoftLimitStop = other.kdSoftLimitStop;
    }

    @XmlElement
    public void setAxis(Vector3D axis) {
        this.axis = axis;
    }

    public void setAxis(Vector3DReadOnly axis) {
        this.axis.set((Tuple3DReadOnly)axis);
    }

    public Vector3D getAxis() {
        return this.axis;
    }

    @XmlElement
    public void setPositionLowerLimit(double positionLowerLimit) {
        this.positionLowerLimit = positionLowerLimit;
    }

    @XmlElement
    public void setPositionUpperLimit(double positionUpperLimit) {
        this.positionUpperLimit = positionUpperLimit;
    }

    public void setPositionLimits(double lowerLimit, double upperLimit) {
        this.setPositionLowerLimit(lowerLimit);
        this.setPositionUpperLimit(upperLimit);
    }

    public double getPositionLowerLimit() {
        return this.positionLowerLimit;
    }

    public double getPositionUpperLimit() {
        return this.positionUpperLimit;
    }

    @XmlElement
    public void setVelocityLowerLimit(double velocityLowerLimit) {
        this.velocityLowerLimit = velocityLowerLimit;
    }

    @XmlElement
    public void setVelocityUpperLimit(double velocityUpperLimit) {
        this.velocityUpperLimit = velocityUpperLimit;
    }

    public void setVelocityLimits(double lowerLimit, double upperLimit) {
        this.setVelocityLowerLimit(lowerLimit);
        this.setVelocityUpperLimit(upperLimit);
    }

    public void setVelocityLimits(double limit) {
        this.setVelocityLowerLimit(-limit);
        this.setVelocityUpperLimit(limit);
    }

    public double getVelocityLowerLimit() {
        return this.velocityLowerLimit;
    }

    public double getVelocityUpperLimit() {
        return this.velocityUpperLimit;
    }

    @XmlElement
    public void setEffortLowerLimit(double effortLowerLimit) {
        this.effortLowerLimit = effortLowerLimit;
    }

    @XmlElement
    public void setEffortUpperLimit(double effortUpperLimit) {
        this.effortUpperLimit = effortUpperLimit;
    }

    public void setEffortLimits(double lowerLimit, double upperLimit) {
        this.setEffortLowerLimit(lowerLimit);
        this.setEffortUpperLimit(upperLimit);
    }

    public void setEffortLimits(double limit) {
        this.setEffortLowerLimit(-limit);
        this.setEffortUpperLimit(limit);
    }

    public double getEffortLowerLimit() {
        return this.effortLowerLimit;
    }

    public double getEffortUpperLimit() {
        return this.effortUpperLimit;
    }

    @XmlElement
    public void setStiction(double stiction) {
        this.stiction = stiction;
    }

    public double getStiction() {
        return this.stiction;
    }

    @XmlElement
    public void setDamping(double damping) {
        this.damping = damping;
    }

    public double getDamping() {
        return this.damping;
    }

    @XmlElement
    public void setKpSoftLimitStop(double kpSoftLimitStop) {
        this.kpSoftLimitStop = kpSoftLimitStop;
    }

    @XmlElement
    public void setKdSoftLimitStop(double kdSoftLimitStop) {
        this.kdSoftLimitStop = kdSoftLimitStop;
    }

    public void setGainsSoftLimitStop(double kpSoftLimitStop, double kdSoftLimitStop) {
        this.kpSoftLimitStop = kpSoftLimitStop;
        this.kdSoftLimitStop = kdSoftLimitStop;
    }

    public double getKpSoftLimitStop() {
        return this.kpSoftLimitStop;
    }

    public double getKdSoftLimitStop() {
        return this.kdSoftLimitStop;
    }
}

