/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Point2DDefinition;

public class ExtrudedPolygon2DDefinition
extends GeometryDefinition {
    private List<Point2DDefinition> polygonVertices = new ArrayList<Point2DDefinition>();
    private boolean counterClockwiseOrdered;
    private double topZ;
    private double bottomZ;

    public ExtrudedPolygon2DDefinition() {
        this.setName("extrudedPolygon2D");
    }

    public ExtrudedPolygon2DDefinition(List<Point2DDefinition> polygonVertices, boolean counterClockwiseOrdered, double extrusionHeight) {
        this();
        this.polygonVertices = polygonVertices;
        this.counterClockwiseOrdered = counterClockwiseOrdered;
        this.topZ = extrusionHeight;
        this.bottomZ = 0.0;
    }

    public ExtrudedPolygon2DDefinition(List<Point2DDefinition> polygonVertices, boolean counterClockwiseOrdered, double topZ, double bottomZ) {
        this();
        this.polygonVertices = polygonVertices;
        this.counterClockwiseOrdered = counterClockwiseOrdered;
        this.topZ = topZ;
        this.bottomZ = bottomZ;
    }

    public ExtrudedPolygon2DDefinition(ExtrudedPolygon2DDefinition other) {
        this.setName(other.getName());
        if (other.polygonVertices != null) {
            this.polygonVertices = other.polygonVertices.stream().map(Point2DDefinition::new).collect(Collectors.toList());
        }
        this.counterClockwiseOrdered = other.counterClockwiseOrdered;
        this.topZ = other.topZ;
        this.bottomZ = other.bottomZ;
    }

    public static List<Point2DDefinition> toPoint2DDefinitionList(Collection<? extends Tuple2DReadOnly> tuple2DCollection) {
        return tuple2DCollection.stream().map(Point2DDefinition::new).collect(Collectors.toList());
    }

    public static List<Point2DDefinition> toPoint3DDefinitionList(Tuple2DReadOnly ... tuple2Ds) {
        return ExtrudedPolygon2DDefinition.toPoint2DDefinitionList(Arrays.asList(tuple2Ds));
    }

    @XmlElement
    public void setPolygonVertices(List<Point2DDefinition> polygonVertices) {
        this.polygonVertices = polygonVertices;
    }

    @XmlElement
    public void setCounterClockwiseOrdered(boolean counterClockwiseOrdered) {
        this.counterClockwiseOrdered = counterClockwiseOrdered;
    }

    @XmlElement
    public void setTopZ(double topZ) {
        this.topZ = topZ;
    }

    @XmlElement
    public void setBottomZ(double bottomZ) {
        this.bottomZ = bottomZ;
    }

    public void setExtrusionHeight(double extrusionHeight) {
        this.topZ = extrusionHeight;
        this.bottomZ = 0.0;
    }

    public List<Point2DDefinition> getPolygonVertices() {
        return this.polygonVertices;
    }

    public boolean isCounterClockwiseOrdered() {
        return this.counterClockwiseOrdered;
    }

    public double getTopZ() {
        return this.topZ;
    }

    public double getBottomZ() {
        return this.bottomZ;
    }

    @Override
    public ExtrudedPolygon2DDefinition copy() {
        return new ExtrudedPolygon2DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.polygonVertices);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.counterClockwiseOrdered);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.topZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.bottomZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ExtrudedPolygon2DDefinition) {
            ExtrudedPolygon2DDefinition other = (ExtrudedPolygon2DDefinition)object;
            if (this.polygonVertices == null ? other.polygonVertices != null : !this.polygonVertices.equals(other.polygonVertices)) {
                return false;
            }
            if (this.counterClockwiseOrdered != other.counterClockwiseOrdered) {
                return false;
            }
            if (this.topZ != other.topZ) {
                return false;
            }
            if (this.bottomZ != other.bottomZ) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        String ordering = this.counterClockwiseOrdered ? "counter-clockwise" : "clockwise";
        return "Extruded Polygon 2D: [name: " + this.getName() + ", " + ordering + ", vertices: " + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", this.polygonVertices, Object::toString);
    }
}

