/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class Box3DDefinition
extends GeometryDefinition {
    private double sizeX;
    private double sizeY;
    private double sizeZ;
    private boolean centered = true;

    public Box3DDefinition() {
        this.setName("box");
    }

    public Box3DDefinition(double sizeX, double sizeY, double sizeZ) {
        this(sizeX, sizeY, sizeZ, true);
    }

    public Box3DDefinition(double sizeX, double sizeY, double sizeZ, boolean centered) {
        this();
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.centered = centered;
    }

    public Box3DDefinition(Tuple3DReadOnly size) {
        this(size.getX(), size.getY(), size.getZ());
    }

    public Box3DDefinition(Box3DDefinition other) {
        this.setName(other.getName());
        this.sizeX = other.sizeX;
        this.sizeY = other.sizeY;
        this.sizeZ = other.sizeZ;
        this.centered = other.centered;
    }

    @XmlElement
    public void setSizeX(double sizeX) {
        this.sizeX = sizeX;
    }

    @XmlElement
    public void setSizeY(double sizeY) {
        this.sizeY = sizeY;
    }

    @XmlElement
    public void setSizeZ(double sizeZ) {
        this.sizeZ = sizeZ;
    }

    public void setSize(double sizeX, double sizeY, double sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void setSize(Tuple3DReadOnly size) {
        this.setSize(size.getX(), size.getY(), size.getZ());
    }

    @XmlElement
    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public double getSizeZ() {
        return this.sizeZ;
    }

    public boolean isCentered() {
        return this.centered;
    }

    @Override
    public Box3DDefinition copy() {
        return new Box3DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sizeX);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sizeY);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.sizeZ);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.centered);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Box3DDefinition) {
            Box3DDefinition other = (Box3DDefinition)object;
            if (this.sizeX != other.sizeX) {
                return false;
            }
            if (this.sizeY != other.sizeY) {
                return false;
            }
            if (this.sizeZ != other.sizeZ) {
                return false;
            }
            if (this.centered != other.centered) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        return EuclidCoreIOTools.getStringOf((String)("Box: [name: " + this.getName() + ", size: ("), (String)")]", (String)", ", (double[])new double[]{this.sizeX, this.sizeY, this.sizeZ});
    }
}

