/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Set;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateBasics;

public class SixDoFJointState
extends JointStateBase
implements SixDoFJointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private final Pose3D configuration = new Pose3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D linearVelocity = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D linearAcceleration = new Vector3D();
    private final Vector3D torque = new Vector3D();
    private final Vector3D force = new Vector3D();

    public SixDoFJointState() {
    }

    public SixDoFJointState(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        this.setConfiguration(orientation, position);
    }

    public SixDoFJointState(SixDoFJointState other) {
        this.configuration.set(other.configuration);
        this.angularVelocity.set(other.angularVelocity);
        this.linearVelocity.set(other.linearVelocity);
        this.angularAcceleration.set(other.angularAcceleration);
        this.linearAcceleration.set(other.linearAcceleration);
        this.torque.set(other.torque);
        this.force.set(other.force);
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    @Override
    public void setConfiguration(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        this.availableStates.add(JointStateType.CONFIGURATION);
        if (orientation != null) {
            this.configuration.getOrientation().set(orientation);
        } else {
            this.configuration.getOrientation().setToZero();
        }
        if (position != null) {
            this.configuration.getPosition().set(position);
        } else {
            this.configuration.getPosition().setToZero();
        }
    }

    @Override
    public void setVelocity(Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity) {
        this.availableStates.add(JointStateType.VELOCITY);
        if (angularVelocity == null) {
            this.angularVelocity.setToZero();
        } else {
            this.angularVelocity.set((Tuple3DReadOnly)angularVelocity);
        }
        if (linearVelocity == null) {
            this.linearVelocity.setToZero();
        } else {
            this.linearVelocity.set((Tuple3DReadOnly)linearVelocity);
        }
    }

    @Override
    public void setAcceleration(Vector3DReadOnly angularAcceleration, Vector3DReadOnly linearAcceleration) {
        this.availableStates.add(JointStateType.ACCELERATION);
        this.angularAcceleration.set((Tuple3DReadOnly)angularAcceleration);
        this.linearAcceleration.set((Tuple3DReadOnly)linearAcceleration);
    }

    @Override
    public void setEffort(Vector3DReadOnly torque, Vector3DReadOnly force) {
        this.availableStates.add(JointStateType.EFFORT);
        this.torque.set((Tuple3DReadOnly)torque);
        this.force.set((Tuple3DReadOnly)force);
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    @Override
    public Pose3DReadOnly getConfiguration() {
        return this.configuration;
    }

    @Override
    public Vector3DReadOnly getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public Vector3DReadOnly getLinearVelocity() {
        return this.linearVelocity;
    }

    @Override
    public Vector3DReadOnly getAngularAcceleration() {
        return this.angularAcceleration;
    }

    @Override
    public Vector3DReadOnly getLinearAcceleration() {
        return this.linearAcceleration;
    }

    @Override
    public Vector3DReadOnly getTorque() {
        return this.torque;
    }

    @Override
    public Vector3DReadOnly getForce() {
        return this.force;
    }

    @Override
    public SixDoFJointState copy() {
        return new SixDoFJointState(this);
    }
}

