/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;

@XmlRootElement(name="Robot")
public class RobotDefinition {
    private String name;
    private RigidBodyDefinition rootBodyDefinition;
    private List<String> nameOfJointsToIgnore = new ArrayList<String>();
    private final List<ControllerDefinition> controllerDefinitions = new ArrayList<ControllerDefinition>();
    private ClassLoader resourceClassLoader;

    public RobotDefinition() {
    }

    public RobotDefinition(String name) {
        this.setName(name);
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="rootBody")
    public void setRootBodyDefinition(RigidBodyDefinition rootBodyDefinition) {
        this.rootBodyDefinition = rootBodyDefinition;
    }

    public void ignoreAllJoints() {
        for (JointDefinition jointDefinition : RobotDefinition.collectSubtreeJointDefinitions(this.rootBodyDefinition)) {
            this.addJointToIgnore(jointDefinition.getName());
        }
    }

    @XmlElement(name="jointToIgnore")
    public void setNameOfJointsToIgnore(List<String> nameOfJointsToIgnore) {
        this.nameOfJointsToIgnore = nameOfJointsToIgnore;
    }

    public void addJointToIgnore(String nameOfJointToIgnore) {
        this.nameOfJointsToIgnore.add(nameOfJointToIgnore);
    }

    public void addSubtreeJointsToIgnore(String nameOfLastJointToConsider) {
        List<JointDefinition> definitionOfJointsToIgnore = RobotDefinition.collectSubtreeJointDefinitions(this.getJointDefinition(nameOfLastJointToConsider).getSuccessor());
        for (JointDefinition jointDefinition : definitionOfJointsToIgnore) {
            this.nameOfJointsToIgnore.add(jointDefinition.getName());
        }
    }

    public void addControllerDefinition(ControllerDefinition controllerDefinition) {
        this.controllerDefinitions.add(controllerDefinition);
    }

    @XmlTransient
    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public String getName() {
        return this.name;
    }

    public RigidBodyDefinition getRootBodyDefinition() {
        return this.rootBodyDefinition;
    }

    public List<JointDefinition> getRootJointDefinitions() {
        return this.rootBodyDefinition.getChildrenJoints();
    }

    public List<String> getNameOfJointsToIgnore() {
        return this.nameOfJointsToIgnore;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public JointDefinition getJointDefinition(String jointName) {
        return this.getAllJoints().stream().filter(joint -> joint.getName().equals(jointName)).findFirst().orElse(null);
    }

    public RigidBodyDefinition getRigidBodyDefinition(String bodyName) {
        if (this.rootBodyDefinition.getName().equals(bodyName)) {
            return this.rootBodyDefinition;
        }
        return this.getAllJoints().stream().map(JointDefinition::getSuccessor).filter(rigidBody -> rigidBody.getName().equals(bodyName)).findFirst().orElse(null);
    }

    public List<JointDefinition> getAllJoints() {
        return RobotDefinition.collectSubtreeJointDefinitions(this.rootBodyDefinition);
    }

    public List<RigidBodyDefinition> getAllRigidBodies() {
        return RobotDefinition.collectSubtreeRigidBodyDefinitions(this.rootBodyDefinition);
    }

    public List<ControllerDefinition> getControllerDefinitions() {
        return this.controllerDefinitions;
    }

    private static List<JointDefinition> collectSubtreeJointDefinitions(RigidBodyDefinition start) {
        return RobotDefinition.collectSubtreeJointDefinitions(start, new ArrayList<JointDefinition>());
    }

    private static List<JointDefinition> collectSubtreeJointDefinitions(RigidBodyDefinition start, List<JointDefinition> jointsToPack) {
        if (start == null || start.getChildrenJoints() == null) {
            return Collections.emptyList();
        }
        for (JointDefinition childJoint : start.getChildrenJoints()) {
            jointsToPack.add(childJoint);
            RobotDefinition.collectSubtreeJointDefinitions(childJoint.getSuccessor(), jointsToPack);
        }
        return jointsToPack;
    }

    private static List<RigidBodyDefinition> collectSubtreeRigidBodyDefinitions(RigidBodyDefinition start) {
        return RobotDefinition.collectSubtreeRigidBodyDefinitions(start, new ArrayList<RigidBodyDefinition>());
    }

    private static List<RigidBodyDefinition> collectSubtreeRigidBodyDefinitions(RigidBodyDefinition start, List<RigidBodyDefinition> rigidBodiesToPack) {
        if (start == null || start.getChildrenJoints() == null) {
            return Collections.emptyList();
        }
        rigidBodiesToPack.add(start);
        for (JointDefinition childJoint : start.getChildrenJoints()) {
            RobotDefinition.collectSubtreeRigidBodyDefinitions(childJoint.getSuccessor(), rigidBodiesToPack);
        }
        return rigidBodiesToPack;
    }

    public RigidBodyBasics newIntance(ReferenceFrame rootFrame) {
        if (this.rootBodyDefinition == null) {
            throw new NullPointerException("The robot " + this.name + " has no definition!");
        }
        RigidBodyBasics rootBody = this.rootBodyDefinition.toRootBody(rootFrame);
        this.instantiateRecursively(rootBody, this.rootBodyDefinition);
        return rootBody;
    }

    private void instantiateRecursively(RigidBodyBasics predecessor, RigidBodyDefinition predecessorDefinition) {
        for (JointDefinition childDefinition : predecessorDefinition.getChildrenJoints()) {
            JointBasics child = childDefinition.toJoint(predecessor);
            RigidBodyDefinition successorDefinition = childDefinition.getSuccessor();
            if (successorDefinition == null) {
                throw new NullPointerException("The joint " + child.getName() + " is missing the definition for its successor, robot name: " + this.name + ".");
            }
            RigidBodyBasics successor = successorDefinition.toRigidBody(child);
            this.instantiateRecursively(successor, successorDefinition);
        }
    }
}

