/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class ArcTorus3DDefinition
extends GeometryDefinition {
    private double startAngle;
    private double endAngle;
    private double majorRadius;
    private double minorRadius;
    private int resolution = 64;

    public ArcTorus3DDefinition() {
        this.setName("arcTorus");
    }

    public ArcTorus3DDefinition(double startAngle, double endAngle, double majorRadius, double minorRadius) {
        this();
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.majorRadius = majorRadius;
        this.minorRadius = minorRadius;
    }

    public ArcTorus3DDefinition(double startAngle, double endAngle, double majorRadius, double minorRadius, int resolution) {
        this();
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.majorRadius = majorRadius;
        this.minorRadius = minorRadius;
        this.resolution = resolution;
    }

    public ArcTorus3DDefinition(ArcTorus3DDefinition other) {
        this();
        this.setName(other.getName());
        this.startAngle = other.startAngle;
        this.endAngle = other.endAngle;
        this.majorRadius = other.majorRadius;
        this.minorRadius = other.minorRadius;
        this.resolution = other.resolution;
    }

    @XmlElement
    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
    }

    @XmlElement
    public void setEndAngle(double endAngle) {
        this.endAngle = endAngle;
    }

    @XmlElement
    public void setMajorRadius(double majorRadius) {
        this.majorRadius = majorRadius;
    }

    @XmlElement
    public void setMinorRadius(double minorRadius) {
        this.minorRadius = minorRadius;
    }

    @XmlElement
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public double getMajorRadius() {
        return this.majorRadius;
    }

    public double getMinorRadius() {
        return this.minorRadius;
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public ArcTorus3DDefinition copy() {
        return new ArcTorus3DDefinition(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.startAngle);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.endAngle);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.majorRadius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.minorRadius);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (float)this.resolution);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.getName());
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArcTorus3DDefinition) {
            ArcTorus3DDefinition other = (ArcTorus3DDefinition)object;
            if (this.startAngle != other.startAngle) {
                return false;
            }
            if (this.endAngle != other.endAngle) {
                return false;
            }
            if (this.majorRadius != other.majorRadius) {
                return false;
            }
            if (this.minorRadius != other.minorRadius) {
                return false;
            }
            if (this.resolution != other.resolution) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "Arc-Torus: [name: " + this.getName() + EuclidCoreIOTools.getStringOf((String)", radii: (", (String)")", (String)", ", (double[])new double[]{this.majorRadius, this.minorRadius}) + ", start angle: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.startAngle) + ", end angle: " + String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.endAngle) + ", resolution: " + this.resolution + "]";
    }
}

