/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBody;
import com.badlogic.gdx.physics.bullet.dynamics.btMultiBodyConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.YoBulletMultiBodyParameters;

public class BulletMultiBodyRobot {
    private final btMultiBody btMultiBody;
    private HashMap<String, Integer> jointNameToBulletJointIndexMap = new HashMap();
    private final ArrayList<BulletMultiBodyLinkCollider> allBulletMultiBodyLinkColliders = new ArrayList();
    private final ArrayList<btMultiBodyConstraint> allBtMultiBodyConstraints = new ArrayList();

    public BulletMultiBodyRobot(int numberOfLinks, float rootBodyMass, Vector3 rootBodyIntertia, boolean fixedBase, boolean canSleep, HashMap<String, Integer> jointNameToBulletJointIndexMap) {
        this.btMultiBody = new btMultiBody(numberOfLinks, rootBodyMass, rootBodyIntertia, fixedBase, canSleep);
        this.jointNameToBulletJointIndexMap = jointNameToBulletJointIndexMap;
    }

    public btMultiBody getBtMultiBody() {
        return this.btMultiBody;
    }

    public ArrayList<BulletMultiBodyLinkCollider> getBulletMultiBodyLinkColliderArray() {
        return this.allBulletMultiBodyLinkColliders;
    }

    public BulletMultiBodyLinkCollider getBulletMultiBodyLinkCollider(int index) {
        return this.allBulletMultiBodyLinkColliders.get(index);
    }

    public ArrayList<btMultiBodyConstraint> getBtMultiBodyConstraintArray() {
        return this.allBtMultiBodyConstraints;
    }

    public HashMap<String, Integer> getJointNameToBulletJointIndexMap() {
        return this.jointNameToBulletJointIndexMap;
    }

    public void addBulletMuliBodyLinkCollider(BulletMultiBodyLinkCollider bulletMultiBodyLinkCollider) {
        this.allBulletMultiBodyLinkColliders.add(bulletMultiBodyLinkCollider);
    }

    public void addBtMultiBodyConstraint(btMultiBodyConstraint btMultiBodyConstraint2) {
        this.allBtMultiBodyConstraints.add(btMultiBodyConstraint2);
    }

    public void finalizeMultiDof(YoBulletMultiBodyParameters bulletMultiBodyParameters, YoBulletMultiBodyJointParameters bulletMultiBodyJointParameters) {
        this.setMultiBodyParameters(bulletMultiBodyParameters);
        this.setMultiBodyJointParameters(bulletMultiBodyJointParameters);
        this.btMultiBody.finalizeMultiDof();
    }

    public void setMultiBodyParameters(YoBulletMultiBodyParameters bulletMultiBodyParameters) {
        this.btMultiBody.setHasSelfCollision(bulletMultiBodyParameters.getHasSelfCollision());
        this.btMultiBody.setCanSleep(bulletMultiBodyParameters.getCanSleep());
        this.btMultiBody.setUseGyroTerm(bulletMultiBodyParameters.getUseGyroTerm());
        this.btMultiBody.useGlobalVelocities(bulletMultiBodyParameters.getUseGlobalVelocities());
        this.btMultiBody.useRK4Integration(bulletMultiBodyParameters.getUseRK4Integration());
        this.btMultiBody.setLinearDamping((float)bulletMultiBodyParameters.getLinearDamping());
        this.btMultiBody.setAngularDamping((float)bulletMultiBodyParameters.getAngularDamping());
        this.btMultiBody.setMaxAppliedImpulse((float)bulletMultiBodyParameters.getMaxAppliedImpulse());
        this.btMultiBody.setMaxCoordinateVelocity((float)bulletMultiBodyParameters.getMaxCoordinateVelocity());
    }

    public void setMultiBodyJointParameters(YoBulletMultiBodyJointParameters bulletMultiBodyJointParameters) {
        for (BulletMultiBodyLinkCollider bulletMultiBodyLinkCollider : this.allBulletMultiBodyLinkColliders) {
            bulletMultiBodyLinkCollider.setFriction(bulletMultiBodyJointParameters.getJointFriction());
            bulletMultiBodyLinkCollider.setRestitution(bulletMultiBodyJointParameters.getJointRestitution());
            bulletMultiBodyLinkCollider.setHitFraction(bulletMultiBodyJointParameters.getJointHitFraction());
            bulletMultiBodyLinkCollider.setRollingFriction(bulletMultiBodyJointParameters.getJointRollingFriction());
            bulletMultiBodyLinkCollider.setSpinningFriction(bulletMultiBodyJointParameters.getJointSpinningFriction());
            bulletMultiBodyLinkCollider.setContactProcessingThreshold(bulletMultiBodyJointParameters.getJointContactProcessingThreshold());
        }
    }
}

