/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import java.util.ArrayList;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletDynamics.btRigidBody;
import org.bytedeco.bullet.LinearMath.btDefaultMotionState;
import org.bytedeco.bullet.LinearMath.btMotionState;
import org.bytedeco.bullet.LinearMath.btVector3;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletTools;

public class BulletTerrainObject {
    private final btRigidBody btRigidBody;
    private final int collisionGroup = 1;
    private final int collisionGroupMask = -1;
    private final btCompoundShape btCollisionShape;
    private ArrayList<btCollisionShape> btCollisionShapes = new ArrayList();
    private final btVector3 localInertia = new btVector3();
    private double friction;
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();
    private final btDefaultMotionState btMotionState = new btDefaultMotionState();

    public BulletTerrainObject(double mass, btCompoundShape bulletCompoundCollisionShape, ArrayList<btCollisionShape> btCollisionShapes) {
        bulletCompoundCollisionShape.calculateLocalInertia(mass, this.localInertia);
        this.btRigidBody = new btRigidBody(mass, (btMotionState)this.btMotionState, (btCollisionShape)bulletCompoundCollisionShape, this.localInertia);
        this.btRigidBody.setFriction(1.0);
        this.friction = this.btRigidBody.getFriction();
        this.btCollisionShape = bulletCompoundCollisionShape;
        this.setBtCollisionShapes(btCollisionShapes);
    }

    public void pullStateFromBullet() {
        this.friction = this.btRigidBody.getFriction();
        BulletTools.toEuclid(this.btRigidBody.getCenterOfMassTransform(), this.transformToWorld);
    }

    public btRigidBody getBtRigidBody() {
        return this.btRigidBody;
    }

    public int getCollisionGroup() {
        return 1;
    }

    public int getCollisionGroupMask() {
        return -1;
    }

    public btCompoundShape getBtCollisionShape() {
        return this.btCollisionShape;
    }

    public ArrayList<btCollisionShape> getBtCollisionShapes() {
        return this.btCollisionShapes;
    }

    public void setBtCollisionShapes(ArrayList<btCollisionShape> btCollisionShapes) {
        this.btCollisionShapes = btCollisionShapes;
    }

    public void setTransformToWorld(RigidBodyTransform transformToWorld) {
        BulletTools.toBullet(transformToWorld, this.btMotionState.m_graphicsWorldTrans());
    }

    public RigidBodyTransform getTransformToWorld() {
        return this.transformToWorld;
    }
}

