/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.bullet.physicsEngine;

import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.MomentOfInertiaDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.simulation.SimulationEnergyStatistics;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.variable.YoDouble;

public class BulletFlyingBallSimulationTest {
    private static final double EPSILON = 0.01;
    private static final boolean BULLET_PHYSICS_ENGINE = true;
    private static final boolean VISUALIZE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlyingBall() throws Throwable {
        final Point3D initialPosition = new Point3D(0.0, 0.0, 0.0);
        final Vector3D initialVelocity = new Vector3D(0.0, 0.0, 0.0);
        double dt = 0.01;
        double ballRadius = 0.2;
        double ballMass = 2.0;
        String name = "sphere";
        RobotDefinition sphereRobot = new RobotDefinition(name);
        RigidBodyDefinition rootBody = new RigidBodyDefinition(name + "RootBody");
        SixDoFJointDefinition rootJoint = new SixDoFJointDefinition(name);
        rootBody.addChildJoint((JointDefinition)rootJoint);
        RigidBodyDefinition rigidBody = new RigidBodyDefinition(name + "RigidBody");
        rigidBody.setMass(ballMass);
        rigidBody.setMomentOfInertia(new MomentOfInertiaDefinition(0.1, 0.1, 0.1));
        rigidBody.addVisualDefinition(new VisualDefinition((GeometryDefinition)new Sphere3DDefinition(0.05), new MaterialDefinition(null, ColorDefinitions.Brown(), ColorDefinitions.LightGray(), null, 10.0)));
        rootJoint.setSuccessor(rigidBody);
        sphereRobot.setRootBodyDefinition(rootBody);
        sphereRobot.getRigidBodyDefinition(name + "RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Sphere3DDefinition(ballRadius)));
        SixDoFJointState sphereInitialState = new SixDoFJointState();
        sphereInitialState.setConfiguration(null, (Tuple3DReadOnly)initialPosition);
        sphereInitialState.setVelocity(null, (Vector3DReadOnly)initialVelocity);
        ((JointDefinition)sphereRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)sphereInitialState);
        SimulationSession simulationSession = null;
        BulletMultiBodyParameters bulletMultiBodyParameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        BulletMultiBodyJointParameters bulletMultiBodyJointParameter = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        bulletMultiBodyParameters.setLinearDamping(0.0);
        bulletMultiBodyParameters.setMaxCoordinateVelocity(1.0E7);
        bulletMultiBodyParameters.setUseRK4Integration(true);
        simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)bulletMultiBodyParameters, (BulletMultiBodyJointParameters)bulletMultiBodyJointParameter));
        int numberOfSimulationTicks = 1000;
        simulationSession.addRobot(sphereRobot);
        simulationSession.setSessionDTSeconds(dt);
        simulationSession.initializeBufferSize(2 * numberOfSimulationTicks);
        SimulationEnergyStatistics.setupSimulationEnergyStatistics((SimulationSession)simulationSession);
        final YoPoint3D expectedPosition = new YoPoint3D("expectedSpherePosition", simulationSession.getRootRegistry());
        YoFrameVector3D gravity = simulationSession.getGravity();
        Object visualizerControls = null;
        SimFloatingRootJoint floatingRootJoint = (SimFloatingRootJoint)((Robot)simulationSession.getPhysicsEngine().getRobots().get(0)).getJoint(name);
        YoDouble orbitalEnergyVariable = (YoDouble)simulationSession.getRootRegistry().findVariable(name + "OrbitalEnergy");
        MutableObject caughtException = new MutableObject(null);
        simulationSession.addRunThrowableListener(t -> caughtException.setValue(t));
        simulationSession.addAfterPhysicsCallback(new TimeConsumer(){
            double initialOrbitalEnergy = 0.0;
            final /* synthetic */ FrameVector3DReadOnly val$gravity;
            final /* synthetic */ SimFloatingRootJoint val$floatingRootJoint;
            final /* synthetic */ YoDouble val$orbitalEnergyVariable;
            {
                this.val$gravity = frameVector3DReadOnly;
                this.val$floatingRootJoint = simFloatingRootJoint;
                this.val$orbitalEnergyVariable = yoDouble;
            }

            public void accept(double time) {
                expectedPosition.set((Tuple3DReadOnly)BulletFlyingBallSimulationTest.this.heightAfterSeconds(initialPosition, initialVelocity, time, this.val$gravity.getZ()));
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)this.val$floatingRootJoint.getJointPose().getPosition(), (double)0.01);
                if (this.initialOrbitalEnergy == 0.0) {
                    this.initialOrbitalEnergy = this.val$orbitalEnergyVariable.getValue();
                }
                Assertions.assertEquals((double)this.initialOrbitalEnergy, (double)this.val$orbitalEnergyVariable.getValue(), (double)0.1, (String)("Orbital Energy failed at time = " + time));
            }
        });
        simulationSession.getSimulationSessionControls().simulateNow((long)numberOfSimulationTicks);
        if (caughtException.getValue() != null) {
            throw (Throwable)caughtException.getValue();
        }
    }

    private Vector3D heightAfterSeconds(Point3D initialPosition, Vector3D initialVelocity, double seconds, double gravity) {
        Vector3D height = new Vector3D();
        height.setX(initialVelocity.getX() * seconds + initialPosition.getX());
        height.setY(initialVelocity.getY() * seconds + initialPosition.getY());
        height.setZ(0.5 * gravity * seconds * seconds + initialVelocity.getZ() * seconds + initialPosition.getZ());
        return height;
    }
}

