/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import visualization_msgs.msg.dds.MeshFile;

public class MeshFilePubSubType
implements TopicDataType<MeshFile> {
    public static final String name = "visualization_msgs::msg::dds_::MeshFile_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "c19edefe9add18099ae26999a09ff7aae73e22be4a29438a74864b166ade8459";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(MeshFile data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        MeshFilePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, MeshFile data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        MeshFilePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return MeshFilePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 100 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(MeshFile data) {
        return MeshFilePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(MeshFile data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getFilename().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getData().size() * 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(MeshFile data, CDR cdr) {
        if (data.getFilename().length() > 255) {
            throw new RuntimeException("filename field exceeds the maximum length: %d > %d".formatted(data.getFilename().length(), 255));
        }
        cdr.write_type_d(data.getFilename());
        if (data.getData().size() > 100) {
            throw new RuntimeException("data field exceeds the maximum length: %d > %d".formatted(data.getData().size(), 100));
        }
        cdr.write_type_e((IDLSequence)data.getData());
    }

    public static void read(MeshFile data, CDR cdr) {
        cdr.read_type_d(data.getFilename());
        cdr.read_type_e((IDLSequence)data.getData());
    }

    public final void serialize(MeshFile data, InterchangeSerializer ser) {
        ser.write_type_d("filename", data.getFilename());
        ser.write_type_e("data", (IDLSequence)data.getData());
    }

    public final void deserialize(InterchangeSerializer ser, MeshFile data) {
        ser.read_type_d("filename", data.getFilename());
        ser.read_type_e("data", (IDLSequence)data.getData());
    }

    public static void staticCopy(MeshFile src, MeshFile dest) {
        dest.set(src);
    }

    public MeshFile createData() {
        return new MeshFile();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)MeshFilePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(MeshFile data, CDR cdr) {
        MeshFilePubSubType.write(data, cdr);
    }

    public void deserialize(MeshFile data, CDR cdr) {
        MeshFilePubSubType.read(data, cdr);
    }

    public void copy(MeshFile src, MeshFile dest) {
        MeshFilePubSubType.staticCopy(src, dest);
    }

    public MeshFilePubSubType newInstance() {
        return new MeshFilePubSubType();
    }
}

