/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import builtin_interfaces.msg.dds.Duration;
import builtin_interfaces.msg.dds.DurationPubSubType;
import geometry_msgs.msg.dds.PointPubSubType;
import java.util.function.Supplier;
import std_msgs.msg.dds.ColorRGBA;
import std_msgs.msg.dds.ColorRGBAPubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import visualization_msgs.msg.dds.ImageMarkerPubSubType;

public class ImageMarker
extends Packet<ImageMarker>
implements Settable<ImageMarker>,
EpsilonComparable<ImageMarker> {
    public static final int CIRCLE = 0;
    public static final int LINE_STRIP = 1;
    public static final int LINE_LIST = 2;
    public static final int POLYGON = 3;
    public static final int POINTS = 4;
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public Header header_ = new Header();
    public StringBuilder ns_ = new StringBuilder(255);
    public int id_;
    public int type_;
    public int action_;
    public Point3D position_ = new Point3D();
    public float scale_;
    public ColorRGBA outline_color_ = new ColorRGBA();
    public byte filled_;
    public ColorRGBA fill_color_ = new ColorRGBA();
    public Duration lifetime_ = new Duration();
    public IDLSequence.Object<Point3D> points_ = new IDLSequence.Object(100, (TopicDataType)new PointPubSubType());
    public IDLSequence.Object<ColorRGBA> outline_colors_ = new IDLSequence.Object(100, (TopicDataType)new ColorRGBAPubSubType());

    public ImageMarker() {
    }

    public ImageMarker(ImageMarker other) {
        this();
        this.set(other);
    }

    public void set(ImageMarker other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.ns_.setLength(0);
        this.ns_.append((CharSequence)other.ns_);
        this.id_ = other.id_;
        this.type_ = other.type_;
        this.action_ = other.action_;
        PointPubSubType.staticCopy(other.position_, this.position_);
        this.scale_ = other.scale_;
        ColorRGBAPubSubType.staticCopy(other.outline_color_, this.outline_color_);
        this.filled_ = other.filled_;
        ColorRGBAPubSubType.staticCopy(other.fill_color_, this.fill_color_);
        DurationPubSubType.staticCopy(other.lifetime_, this.lifetime_);
        this.points_.set(other.points_);
        this.outline_colors_.set(other.outline_colors_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setNs(String ns) {
        this.ns_.setLength(0);
        this.ns_.append(ns);
    }

    public String getNsAsString() {
        return this.getNs().toString();
    }

    public StringBuilder getNs() {
        return this.ns_;
    }

    public void setId(int id) {
        this.id_ = id;
    }

    public int getId() {
        return this.id_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public int getType() {
        return this.type_;
    }

    public void setAction(int action) {
        this.action_ = action;
    }

    public int getAction() {
        return this.action_;
    }

    public Point3D getPosition() {
        return this.position_;
    }

    public void setScale(float scale) {
        this.scale_ = scale;
    }

    public float getScale() {
        return this.scale_;
    }

    public ColorRGBA getOutlineColor() {
        return this.outline_color_;
    }

    public void setFilled(byte filled) {
        this.filled_ = filled;
    }

    public byte getFilled() {
        return this.filled_;
    }

    public ColorRGBA getFillColor() {
        return this.fill_color_;
    }

    public Duration getLifetime() {
        return this.lifetime_;
    }

    public IDLSequence.Object<Point3D> getPoints() {
        return this.points_;
    }

    public IDLSequence.Object<ColorRGBA> getOutlineColors() {
        return this.outline_colors_;
    }

    public static Supplier<ImageMarkerPubSubType> getPubSubType() {
        return ImageMarkerPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return ImageMarkerPubSubType::new;
    }

    public boolean epsilonEquals(ImageMarker other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.ns_, (StringBuilder)other.ns_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.id_, (double)other.id_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.type_, (double)other.type_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.action_, (double)other.action_, (double)epsilon)) {
            return false;
        }
        if (!this.position_.epsilonEquals((EuclidGeometry)other.position_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.scale_, (double)other.scale_, (double)epsilon)) {
            return false;
        }
        if (!this.outline_color_.epsilonEquals(other.outline_color_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.filled_, (double)other.filled_, (double)epsilon)) {
            return false;
        }
        if (!this.fill_color_.epsilonEquals(other.fill_color_, epsilon)) {
            return false;
        }
        if (!this.lifetime_.epsilonEquals(other.lifetime_, epsilon)) {
            return false;
        }
        if (this.points_.size() != other.points_.size()) {
            return false;
        }
        for (i = 0; i < this.points_.size(); ++i) {
            if (((Point3D)this.points_.get(i)).epsilonEquals((EuclidGeometry)other.points_.get(i), epsilon)) continue;
            return false;
        }
        if (this.outline_colors_.size() != other.outline_colors_.size()) {
            return false;
        }
        for (i = 0; i < this.outline_colors_.size(); ++i) {
            if (((ColorRGBA)((Object)this.outline_colors_.get(i))).epsilonEquals((ColorRGBA)((Object)other.outline_colors_.get(i)), epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ImageMarker)) {
            return false;
        }
        ImageMarker otherMyClass = (ImageMarker)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.ns_, (StringBuilder)otherMyClass.ns_)) {
            return false;
        }
        if (this.id_ != otherMyClass.id_) {
            return false;
        }
        if (this.type_ != otherMyClass.type_) {
            return false;
        }
        if (this.action_ != otherMyClass.action_) {
            return false;
        }
        if (!this.position_.equals((EuclidGeometry)otherMyClass.position_)) {
            return false;
        }
        if (this.scale_ != otherMyClass.scale_) {
            return false;
        }
        if (!this.outline_color_.equals((Object)otherMyClass.outline_color_)) {
            return false;
        }
        if (this.filled_ != otherMyClass.filled_) {
            return false;
        }
        if (!this.fill_color_.equals((Object)otherMyClass.fill_color_)) {
            return false;
        }
        if (!this.lifetime_.equals((Object)otherMyClass.lifetime_)) {
            return false;
        }
        if (!this.points_.equals(otherMyClass.points_)) {
            return false;
        }
        return this.outline_colors_.equals(otherMyClass.outline_colors_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImageMarker {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("ns=");
        builder.append((CharSequence)this.ns_);
        builder.append(", ");
        builder.append("id=");
        builder.append(this.id_);
        builder.append(", ");
        builder.append("type=");
        builder.append(this.type_);
        builder.append(", ");
        builder.append("action=");
        builder.append(this.action_);
        builder.append(", ");
        builder.append("position=");
        builder.append(this.position_);
        builder.append(", ");
        builder.append("scale=");
        builder.append(this.scale_);
        builder.append(", ");
        builder.append("outline_color=");
        builder.append((Object)this.outline_color_);
        builder.append(", ");
        builder.append("filled=");
        builder.append(this.filled_);
        builder.append(", ");
        builder.append("fill_color=");
        builder.append((Object)this.fill_color_);
        builder.append(", ");
        builder.append("lifetime=");
        builder.append((Object)this.lifetime_);
        builder.append(", ");
        builder.append("points=");
        builder.append(this.points_);
        builder.append(", ");
        builder.append("outline_colors=");
        builder.append(this.outline_colors_);
        builder.append("}");
        return builder.toString();
    }
}

