/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs.msg.dds;

import geometry_msgs.msg.dds.PointPubSubType;
import java.io.IOException;
import nav_msgs.msg.dds.GridCells;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class GridCellsPubSubType
implements TopicDataType<GridCells> {
    public static final String name = "nav_msgs::msg::dds_::GridCells_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "25da9fb0f1b14f317b4c8f0d178db20114b4b6d0a86174f5b424d420f37ece78";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(GridCells data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        GridCellsPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, GridCells data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        GridCellsPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return GridCellsPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += PointPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(GridCells data) {
        return GridCellsPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(GridCells data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getCells().size(); ++i0) {
            current_alignment += PointPubSubType.getCdrSerializedSize((Point3D)data.getCells().get(i0), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(GridCells data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        cdr.write_type_5(data.getCellWidth());
        cdr.write_type_5(data.getCellHeight());
        if (data.getCells().size() > 100) {
            throw new RuntimeException("cells field exceeds the maximum length: %d > %d".formatted(data.getCells().size(), 100));
        }
        cdr.write_type_e(data.getCells());
    }

    public static void read(GridCells data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        data.setCellWidth(cdr.read_type_5());
        data.setCellHeight(cdr.read_type_5());
        cdr.read_type_e(data.getCells());
    }

    public final void serialize(GridCells data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_5("cell_width", data.getCellWidth());
        ser.write_type_5("cell_height", data.getCellHeight());
        ser.write_type_e("cells", data.getCells());
    }

    public final void deserialize(InterchangeSerializer ser, GridCells data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        data.setCellWidth(ser.read_type_5("cell_width"));
        data.setCellHeight(ser.read_type_5("cell_height"));
        ser.read_type_e("cells", data.getCells());
    }

    public static void staticCopy(GridCells src, GridCells dest) {
        dest.set(src);
    }

    public GridCells createData() {
        return new GridCells();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)GridCellsPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(GridCells data, CDR cdr) {
        GridCellsPubSubType.write(data, cdr);
    }

    public void deserialize(GridCells data, CDR cdr) {
        GridCellsPubSubType.read(data, cdr);
    }

    public void copy(GridCells src, GridCells dest) {
        GridCellsPubSubType.staticCopy(src, dest);
    }

    public GridCellsPubSubType newInstance() {
        return new GridCellsPubSubType();
    }
}

