/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.io.IOException;
import sensor_msgs.msg.dds.CameraInfo;
import sensor_msgs.msg.dds.RegionOfInterestPubSubType;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class CameraInfoPubSubType
implements TopicDataType<CameraInfo> {
    public static final String name = "sensor_msgs::msg::dds_::CameraInfo_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "5dfbf4cbb6dcab34f05ef8c8b08aff9b776de6ed52493ede25882f438392e138";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(CameraInfo data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        CameraInfoPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, CameraInfo data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        CameraInfoPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return CameraInfoPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 800 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 96 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += RegionOfInterestPubSubType.getMaxCdrSerializedSize(current_alignment);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(CameraInfo data) {
        return CameraInfoPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(CameraInfo data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getDistortionModel().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getD().size() * 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 72 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 96 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += RegionOfInterestPubSubType.getCdrSerializedSize(data.getRoi(), current_alignment);
        return current_alignment - initial_alignment;
    }

    public static void write(CameraInfo data, CDR cdr) {
        int i0;
        HeaderPubSubType.write(data.getHeader(), cdr);
        cdr.write_type_4(data.getHeight());
        cdr.write_type_4(data.getWidth());
        if (data.getDistortionModel().length() > 255) {
            throw new RuntimeException("distortion_model field exceeds the maximum length");
        }
        cdr.write_type_d(data.getDistortionModel());
        if (data.getD().size() > 100) {
            throw new RuntimeException("d field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getD());
        for (i0 = 0; i0 < data.getK().length; ++i0) {
            cdr.write_type_6(data.getK()[i0]);
        }
        for (i0 = 0; i0 < data.getR().length; ++i0) {
            cdr.write_type_6(data.getR()[i0]);
        }
        for (i0 = 0; i0 < data.getP().length; ++i0) {
            cdr.write_type_6(data.getP()[i0]);
        }
        cdr.write_type_4(data.getBinningX());
        cdr.write_type_4(data.getBinningY());
        RegionOfInterestPubSubType.write(data.getRoi(), cdr);
    }

    public static void read(CameraInfo data, CDR cdr) {
        int i0;
        HeaderPubSubType.read(data.getHeader(), cdr);
        data.setHeight(cdr.read_type_4());
        data.setWidth(cdr.read_type_4());
        cdr.read_type_d(data.getDistortionModel());
        cdr.read_type_e((IDLSequence)data.getD());
        for (i0 = 0; i0 < data.getK().length; ++i0) {
            data.getK()[i0] = cdr.read_type_6();
        }
        for (i0 = 0; i0 < data.getR().length; ++i0) {
            data.getR()[i0] = cdr.read_type_6();
        }
        for (i0 = 0; i0 < data.getP().length; ++i0) {
            data.getP()[i0] = cdr.read_type_6();
        }
        data.setBinningX(cdr.read_type_4());
        data.setBinningY(cdr.read_type_4());
        RegionOfInterestPubSubType.read(data.getRoi(), cdr);
    }

    public final void serialize(CameraInfo data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_4("height", data.getHeight());
        ser.write_type_4("width", data.getWidth());
        ser.write_type_d("distortion_model", data.getDistortionModel());
        ser.write_type_e("d", (IDLSequence)data.getD());
        ser.write_type_f("k", data.getK());
        ser.write_type_f("r", data.getR());
        ser.write_type_f("p", data.getP());
        ser.write_type_4("binning_x", data.getBinningX());
        ser.write_type_4("binning_y", data.getBinningY());
        ser.write_type_a("roi", (TopicDataType)new RegionOfInterestPubSubType(), (Object)data.getRoi());
    }

    public final void deserialize(InterchangeSerializer ser, CameraInfo data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        data.setHeight(ser.read_type_4("height"));
        data.setWidth(ser.read_type_4("width"));
        ser.read_type_d("distortion_model", data.getDistortionModel());
        ser.read_type_e("d", (IDLSequence)data.getD());
        ser.read_type_f("k", data.getK());
        ser.read_type_f("r", data.getR());
        ser.read_type_f("p", data.getP());
        data.setBinningX(ser.read_type_4("binning_x"));
        data.setBinningY(ser.read_type_4("binning_y"));
        ser.read_type_a("roi", (TopicDataType)new RegionOfInterestPubSubType(), (Object)data.getRoi());
    }

    public static void staticCopy(CameraInfo src, CameraInfo dest) {
        dest.set(src);
    }

    public CameraInfo createData() {
        return new CameraInfo();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)CameraInfoPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(CameraInfo data, CDR cdr) {
        CameraInfoPubSubType.write(data, cdr);
    }

    public void deserialize(CameraInfo data, CDR cdr) {
        CameraInfoPubSubType.read(data, cdr);
    }

    public void copy(CameraInfo src, CameraInfo dest) {
        CameraInfoPubSubType.staticCopy(src, dest);
    }

    public CameraInfoPubSubType newInstance() {
        return new CameraInfoPubSubType();
    }
}

