/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import builtin_interfaces.msg.dds.DurationPubSubType;
import geometry_msgs.msg.dds.PointPubSubType;
import java.io.IOException;
import std_msgs.msg.dds.ColorRGBA;
import std_msgs.msg.dds.ColorRGBAPubSubType;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import visualization_msgs.msg.dds.ImageMarker;

public class ImageMarkerPubSubType
implements TopicDataType<ImageMarker> {
    public static final String name = "visualization_msgs::msg::dds_::ImageMarker_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "4982b9434398fcf7d99bd58020953884c105759fce5861ac1907c41f901f25ee";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(ImageMarker data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ImageMarkerPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, ImageMarker data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ImageMarkerPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ImageMarkerPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PointPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += ColorRGBAPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += ColorRGBAPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += DurationPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += PointPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < 100; ++i0) {
            current_alignment += ColorRGBAPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(ImageMarker data) {
        return ImageMarkerPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(ImageMarker data, int current_alignment) {
        int i0;
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getNs().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PointPubSubType.getCdrSerializedSize(data.getPosition(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += ColorRGBAPubSubType.getCdrSerializedSize(data.getOutlineColor(), current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += ColorRGBAPubSubType.getCdrSerializedSize(data.getFillColor(), current_alignment);
        current_alignment += DurationPubSubType.getCdrSerializedSize(data.getLifetime(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getPoints().size(); ++i0) {
            current_alignment += PointPubSubType.getCdrSerializedSize((Point3D)data.getPoints().get(i0), current_alignment);
        }
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (i0 = 0; i0 < data.getOutlineColors().size(); ++i0) {
            current_alignment += ColorRGBAPubSubType.getCdrSerializedSize((ColorRGBA)((Object)data.getOutlineColors().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(ImageMarker data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getNs().length() > 255) {
            throw new RuntimeException("ns field exceeds the maximum length");
        }
        cdr.write_type_d(data.getNs());
        cdr.write_type_2(data.getId());
        cdr.write_type_2(data.getType());
        cdr.write_type_2(data.getAction());
        PointPubSubType.write(data.getPosition(), cdr);
        cdr.write_type_5(data.getScale());
        ColorRGBAPubSubType.write(data.getOutlineColor(), cdr);
        cdr.write_type_9(data.getFilled());
        ColorRGBAPubSubType.write(data.getFillColor(), cdr);
        DurationPubSubType.write(data.getLifetime(), cdr);
        if (data.getPoints().size() > 100) {
            throw new RuntimeException("points field exceeds the maximum length");
        }
        cdr.write_type_e(data.getPoints());
        if (data.getOutlineColors().size() > 100) {
            throw new RuntimeException("outline_colors field exceeds the maximum length");
        }
        cdr.write_type_e(data.getOutlineColors());
    }

    public static void read(ImageMarker data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_d(data.getNs());
        data.setId(cdr.read_type_2());
        data.setType(cdr.read_type_2());
        data.setAction(cdr.read_type_2());
        PointPubSubType.read(data.getPosition(), cdr);
        data.setScale(cdr.read_type_5());
        ColorRGBAPubSubType.read(data.getOutlineColor(), cdr);
        data.setFilled(cdr.read_type_9());
        ColorRGBAPubSubType.read(data.getFillColor(), cdr);
        DurationPubSubType.read(data.getLifetime(), cdr);
        cdr.read_type_e(data.getPoints());
        cdr.read_type_e(data.getOutlineColors());
    }

    public final void serialize(ImageMarker data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_d("ns", data.getNs());
        ser.write_type_2("id", data.getId());
        ser.write_type_2("type", data.getType());
        ser.write_type_2("action", data.getAction());
        ser.write_type_a("position", (TopicDataType)new PointPubSubType(), (Object)data.getPosition());
        ser.write_type_5("scale", data.getScale());
        ser.write_type_a("outline_color", (TopicDataType)new ColorRGBAPubSubType(), (Object)data.getOutlineColor());
        ser.write_type_9("filled", data.getFilled());
        ser.write_type_a("fill_color", (TopicDataType)new ColorRGBAPubSubType(), (Object)data.getFillColor());
        ser.write_type_a("lifetime", (TopicDataType)new DurationPubSubType(), (Object)data.getLifetime());
        ser.write_type_e("points", data.getPoints());
        ser.write_type_e("outline_colors", data.getOutlineColors());
    }

    public final void deserialize(InterchangeSerializer ser, ImageMarker data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_d("ns", data.getNs());
        data.setId(ser.read_type_2("id"));
        data.setType(ser.read_type_2("type"));
        data.setAction(ser.read_type_2("action"));
        ser.read_type_a("position", (TopicDataType)new PointPubSubType(), (Object)data.getPosition());
        data.setScale(ser.read_type_5("scale"));
        ser.read_type_a("outline_color", (TopicDataType)new ColorRGBAPubSubType(), (Object)data.getOutlineColor());
        data.setFilled(ser.read_type_9("filled"));
        ser.read_type_a("fill_color", (TopicDataType)new ColorRGBAPubSubType(), (Object)data.getFillColor());
        ser.read_type_a("lifetime", (TopicDataType)new DurationPubSubType(), (Object)data.getLifetime());
        ser.read_type_e("points", data.getPoints());
        ser.read_type_e("outline_colors", data.getOutlineColors());
    }

    public static void staticCopy(ImageMarker src, ImageMarker dest) {
        dest.set(src);
    }

    public ImageMarker createData() {
        return new ImageMarker();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ImageMarkerPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(ImageMarker data, CDR cdr) {
        ImageMarkerPubSubType.write(data, cdr);
    }

    public void deserialize(ImageMarker data, CDR cdr) {
        ImageMarkerPubSubType.read(data, cdr);
    }

    public void copy(ImageMarker src, ImageMarker dest) {
        ImageMarkerPubSubType.staticCopy(src, dest);
    }

    public ImageMarkerPubSubType newInstance() {
        return new ImageMarkerPubSubType();
    }
}

