/*
 * Decompiled with CFR 0.152.
 */
package trajectory_msgs.msg.dds;

import builtin_interfaces.msg.dds.Duration;
import builtin_interfaces.msg.dds.DurationPubSubType;
import geometry_msgs.msg.dds.TransformPubSubType;
import geometry_msgs.msg.dds.Twist;
import geometry_msgs.msg.dds.TwistPubSubType;
import java.util.function.Supplier;
import trajectory_msgs.msg.dds.MultiDOFJointTrajectoryPointPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.idl.IDLSequence;
import us.ihmc.pubsub.TopicDataType;

public class MultiDOFJointTrajectoryPoint
extends Packet<MultiDOFJointTrajectoryPoint>
implements Settable<MultiDOFJointTrajectoryPoint>,
EpsilonComparable<MultiDOFJointTrajectoryPoint> {
    public IDLSequence.Object<QuaternionBasedTransform> transforms_ = new IDLSequence.Object(100, (TopicDataType)new TransformPubSubType());
    public IDLSequence.Object<Twist> velocities_ = new IDLSequence.Object(100, (TopicDataType)new TwistPubSubType());
    public IDLSequence.Object<Twist> accelerations_ = new IDLSequence.Object(100, (TopicDataType)new TwistPubSubType());
    public Duration time_from_start_ = new Duration();

    public MultiDOFJointTrajectoryPoint() {
    }

    public MultiDOFJointTrajectoryPoint(MultiDOFJointTrajectoryPoint other) {
        this();
        this.set(other);
    }

    public void set(MultiDOFJointTrajectoryPoint other) {
        this.transforms_.set(other.transforms_);
        this.velocities_.set(other.velocities_);
        this.accelerations_.set(other.accelerations_);
        DurationPubSubType.staticCopy(other.time_from_start_, this.time_from_start_);
    }

    public IDLSequence.Object<QuaternionBasedTransform> getTransforms() {
        return this.transforms_;
    }

    public IDLSequence.Object<Twist> getVelocities() {
        return this.velocities_;
    }

    public IDLSequence.Object<Twist> getAccelerations() {
        return this.accelerations_;
    }

    public Duration getTimeFromStart() {
        return this.time_from_start_;
    }

    public static Supplier<MultiDOFJointTrajectoryPointPubSubType> getPubSubType() {
        return MultiDOFJointTrajectoryPointPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return MultiDOFJointTrajectoryPointPubSubType::new;
    }

    public boolean epsilonEquals(MultiDOFJointTrajectoryPoint other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.transforms_.size() != other.transforms_.size()) {
            return false;
        }
        for (i = 0; i < this.transforms_.size(); ++i) {
            if (((QuaternionBasedTransform)this.transforms_.get(i)).epsilonEquals((EuclidGeometry)other.transforms_.get(i), epsilon)) continue;
            return false;
        }
        if (this.velocities_.size() != other.velocities_.size()) {
            return false;
        }
        for (i = 0; i < this.velocities_.size(); ++i) {
            if (((Twist)((Object)this.velocities_.get(i))).epsilonEquals((Twist)((Object)other.velocities_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.accelerations_.size() != other.accelerations_.size()) {
            return false;
        }
        for (i = 0; i < this.accelerations_.size(); ++i) {
            if (((Twist)((Object)this.accelerations_.get(i))).epsilonEquals((Twist)((Object)other.accelerations_.get(i)), epsilon)) continue;
            return false;
        }
        return this.time_from_start_.epsilonEquals(other.time_from_start_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiDOFJointTrajectoryPoint)) {
            return false;
        }
        MultiDOFJointTrajectoryPoint otherMyClass = (MultiDOFJointTrajectoryPoint)((Object)other);
        if (!this.transforms_.equals(otherMyClass.transforms_)) {
            return false;
        }
        if (!this.velocities_.equals(otherMyClass.velocities_)) {
            return false;
        }
        if (!this.accelerations_.equals(otherMyClass.accelerations_)) {
            return false;
        }
        return this.time_from_start_.equals((Object)otherMyClass.time_from_start_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultiDOFJointTrajectoryPoint {");
        builder.append("transforms=");
        builder.append(this.transforms_);
        builder.append(", ");
        builder.append("velocities=");
        builder.append(this.velocities_);
        builder.append(", ");
        builder.append("accelerations=");
        builder.append(this.accelerations_);
        builder.append(", ");
        builder.append("time_from_start=");
        builder.append((Object)this.time_from_start_);
        builder.append("}");
        return builder.toString();
    }
}

