/*
 * Decompiled with CFR 0.152.
 */
package geometry_msgs.msg.dds;

import geometry_msgs.msg.dds.PoseArray;
import geometry_msgs.msg.dds.PosePubSubType;
import java.io.IOException;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class PoseArrayPubSubType
implements TopicDataType<PoseArray> {
    public static final String name = "geometry_msgs::msg::dds_::PoseArray_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "f3b60d4ba3e4c639be38f248644baa1db9580009aba589acf6204c53c8c1d097";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(PoseArray data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        PoseArrayPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, PoseArray data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        PoseArrayPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return PoseArrayPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += PosePubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(PoseArray data) {
        return PoseArrayPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(PoseArray data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getPoses().size(); ++i0) {
            current_alignment += PosePubSubType.getCdrSerializedSize((Pose3D)data.getPoses().get(i0), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(PoseArray data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getPoses().size() > 100) {
            throw new RuntimeException("poses field exceeds the maximum length");
        }
        cdr.write_type_e(data.getPoses());
    }

    public static void read(PoseArray data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_e(data.getPoses());
    }

    public final void serialize(PoseArray data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_e("poses", data.getPoses());
    }

    public final void deserialize(InterchangeSerializer ser, PoseArray data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_e("poses", data.getPoses());
    }

    public static void staticCopy(PoseArray src, PoseArray dest) {
        dest.set(src);
    }

    public PoseArray createData() {
        return new PoseArray();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)PoseArrayPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(PoseArray data, CDR cdr) {
        PoseArrayPubSubType.write(data, cdr);
    }

    public void deserialize(PoseArray data, CDR cdr) {
        PoseArrayPubSubType.read(data, cdr);
    }

    public void copy(PoseArray src, PoseArray dest) {
        PoseArrayPubSubType.staticCopy(src, dest);
    }

    public PoseArrayPubSubType newInstance() {
        return new PoseArrayPubSubType();
    }
}

