/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;

public class SpatialImpulse
implements SpatialImpulseBasics,
GeometryObject<SpatialImpulse> {
    private ReferenceFrame bodyFrame;
    private final SpatialForce spatialForceVector = new SpatialForce();

    public SpatialImpulse() {
        this.setToZero(null, null);
    }

    public SpatialImpulse(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setToZero(bodyFrame, expressedInFrame);
    }

    public SpatialImpulse(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, angularPart, linearPart);
    }

    public SpatialImpulse(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, DMatrix matrix) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, matrix);
    }

    public SpatialImpulse(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double[] array) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, array);
    }

    public SpatialImpulse(ReferenceFrame bodyFrame, SpatialVectorReadOnly spatialVector) {
        this.setIncludingFrame(bodyFrame, spatialVector);
    }

    public SpatialImpulse(SpatialImpulseReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(SpatialImpulse other) {
        SpatialImpulseBasics.super.set(other);
    }

    @Override
    public void setBodyFrame(ReferenceFrame bodyFrame) {
        this.bodyFrame = bodyFrame;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.spatialForceVector.setReferenceFrame(expressedInFrame);
    }

    @Override
    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.spatialForceVector.getReferenceFrame();
    }

    @Override
    public FixedFrameVector3DBasics getAngularPart() {
        return this.spatialForceVector.getAngularPart();
    }

    @Override
    public FixedFrameVector3DBasics getLinearPart() {
        return this.spatialForceVector.getLinearPart();
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        this.spatialForceVector.changeFrame(desiredFrame);
    }

    @Override
    public void applyTransform(Transform transform) {
        this.spatialForceVector.applyTransform(transform);
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        this.spatialForceVector.applyInverseTransform(transform);
    }

    public boolean epsilonEquals(SpatialImpulse other, double epsilon) {
        return SpatialImpulseBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(SpatialImpulse other, double epsilon) {
        return SpatialImpulseBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialImpulseReadOnly) {
            return SpatialImpulseBasics.super.equals((SpatialImpulseReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getSpatialImpulseString(this);
    }
}

