/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public interface TwistBasics
extends FixedFrameTwistBasics,
SpatialMotionBasics {
    default public void add(TwistReadOnly other) {
        this.checkExpressedInFrameMatch(other.getReferenceFrame());
        if (this.getBodyFrame() == other.getBaseFrame()) {
            this.setBodyFrame(other.getBodyFrame());
        } else if (this.getBaseFrame() == other.getBodyFrame()) {
            this.setBaseFrame(other.getBaseFrame());
        } else {
            throw new ReferenceFrameMismatchException("This twist and other are incompatible for addition.");
        }
        this.getAngularPart().add((Tuple3DReadOnly)other.getAngularPart());
        this.getLinearPart().add((Tuple3DReadOnly)other.getLinearPart());
    }

    default public void sub(TwistReadOnly other) {
        this.checkExpressedInFrameMatch(other.getReferenceFrame());
        if (this.getBaseFrame() == other.getBaseFrame()) {
            this.setBaseFrame(other.getBodyFrame());
        } else if (this.getBodyFrame() == other.getBodyFrame()) {
            this.setBodyFrame(other.getBaseFrame());
        } else {
            throw new ReferenceFrameMismatchException("This twist and other are incompatible for difference.");
        }
        this.getAngularPart().sub((Tuple3DReadOnly)other.getAngularPart());
        this.getLinearPart().sub((Tuple3DReadOnly)other.getLinearPart());
    }
}

