/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoIOTools;

public class Twist
implements TwistBasics,
GeometryObject<Twist> {
    private ReferenceFrame bodyFrame;
    private ReferenceFrame baseFrame;
    private final SpatialVector spatialVector = new SpatialVector();
    private final Point3D observerPosition = new Point3D();
    private RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public Twist() {
        this.setToZero(null, null, null);
    }

    public Twist(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
        this.setToZero(bodyFrame, baseFrame, expressedInFrame);
    }

    public Twist(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setIncludingFrame(bodyFrame, baseFrame, expressedInFrame, angularPart, linearPart);
    }

    public Twist(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        this.setIncludingFrame(bodyFrame, baseFrame, angularPart, linearPart);
    }

    public Twist(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, SpatialVectorReadOnly spatialVector) {
        this.setIncludingFrame(bodyFrame, baseFrame, spatialVector);
    }

    public Twist(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, DMatrix matrix) {
        this.setIncludingFrame(bodyFrame, baseFrame, expressedInFrame, matrix);
    }

    public Twist(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, double[] array) {
        this.setIncludingFrame(bodyFrame, baseFrame, expressedInFrame, array);
    }

    public Twist(SpatialMotionReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(Twist other) {
        TwistBasics.super.set((SpatialMotionReadOnly)other);
    }

    @Override
    public void setBaseFrame(ReferenceFrame baseFrame) {
        this.baseFrame = baseFrame;
    }

    @Override
    public void setBodyFrame(ReferenceFrame bodyFrame) {
        this.bodyFrame = bodyFrame;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.spatialVector.setReferenceFrame(expressedInFrame);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (this.getReferenceFrame() == desiredFrame) {
            return;
        }
        this.getReferenceFrame().getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform((RigidBodyTransformReadOnly)this.transformToDesiredFrame);
        this.setReferenceFrame(desiredFrame);
    }

    @Override
    public void applyTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.observerPosition.setToZero();
            this.observerPosition.applyTransform(transform);
            this.spatialVector.applyTransform(transform);
            this.addCrossToLinearPart((Tuple3DReadOnly)this.observerPosition, (Tuple3DReadOnly)this.getAngularPart());
        }
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyInverseTransform((RigidBodyTransformReadOnly)((RigidBodyTransform)transform));
        } else {
            this.observerPosition.setToZero();
            this.observerPosition.applyInverseTransform(transform);
            this.spatialVector.applyInverseTransform(transform);
            this.addCrossToLinearPart((Tuple3DReadOnly)this.observerPosition, (Tuple3DReadOnly)this.getAngularPart());
        }
    }

    @Override
    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    @Override
    public ReferenceFrame getBaseFrame() {
        return this.baseFrame;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.spatialVector.getReferenceFrame();
    }

    @Override
    public FixedFrameVector3DBasics getAngularPart() {
        return this.spatialVector.getAngularPart();
    }

    @Override
    public FixedFrameVector3DBasics getLinearPart() {
        return this.spatialVector.getLinearPart();
    }

    public boolean epsilonEquals(Twist other, double epsilon) {
        return TwistBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(Twist other, double epsilon) {
        return TwistBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TwistReadOnly) {
            return TwistBasics.super.equals((TwistReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getTwistString(this);
    }
}

