/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;

public abstract class OneDoFJoint
extends Joint
implements OneDoFJointBasics {
    private final TwistReadOnly jointTwist;
    private final TwistReadOnly unitJointTwist;
    private final List<TwistReadOnly> unitTwists;
    private TwistReadOnly unitSuccessorTwist;
    private TwistReadOnly unitPredecessorTwist;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private final SpatialAccelerationReadOnly unitJointAcceleration;
    private SpatialAccelerationReadOnly unitSuccessorAcceleration;
    private SpatialAccelerationReadOnly unitPredecessorAcceleration;
    private WrenchReadOnly jointWrench;
    private WrenchReadOnly unitJointWrench;
    private double q;
    private double qd;
    private double qdd;
    private double tau;
    private double jointLimitLower = Double.NEGATIVE_INFINITY;
    private double jointLimitUpper = Double.POSITIVE_INFINITY;
    private double velocityLimitLower = Double.NEGATIVE_INFINITY;
    private double velocityLimitUpper = Double.POSITIVE_INFINITY;
    private double effortLimitLower = Double.NEGATIVE_INFINITY;
    private double effortLimitUpper = Double.POSITIVE_INFINITY;

    public OneDoFJoint(String name, RigidBodyBasics predecessor, Vector3DReadOnly jointAxisAngularPart, Vector3DReadOnly jointAxisLinearPart, RigidBodyTransformReadOnly transformToParent) {
        super(name, predecessor, transformToParent);
        this.unitJointTwist = new Twist(this.afterJointFrame, this.beforeJointFrame, this.afterJointFrame, jointAxisAngularPart, jointAxisLinearPart);
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, this.unitJointTwist);
        this.unitJointAcceleration = new SpatialAcceleration(this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, this.unitJointAcceleration);
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame predecessorFrame = this.getPredecessor().getBodyFixedFrame();
        MovingReferenceFrame successorFrame = this.getSuccessor().getBodyFixedFrame();
        Twist twist = new Twist(this.unitJointTwist);
        twist.setBaseFrame(predecessorFrame);
        twist.setBodyFrame(successorFrame);
        twist.changeFrame(successorFrame);
        this.unitSuccessorTwist = twist;
        twist = new Twist(this.unitSuccessorTwist);
        twist.invert();
        twist.changeFrame(predecessorFrame);
        this.unitPredecessorTwist = twist;
        SpatialAcceleration acceleration = new SpatialAcceleration(this.unitJointAcceleration);
        acceleration.setBaseFrame(predecessorFrame);
        acceleration.setBodyFrame(successorFrame);
        acceleration.changeFrame(successorFrame);
        this.unitSuccessorAcceleration = acceleration;
        acceleration = new SpatialAcceleration(this.unitSuccessorAcceleration);
        acceleration.invert();
        acceleration.changeFrame(predecessorFrame);
        this.unitPredecessorAcceleration = acceleration;
        Wrench wrench = new Wrench();
        wrench.setIncludingFrame(this.unitJointTwist);
        wrench.setBodyFrame(successorFrame);
        wrench.changeFrame(this.afterJointFrame);
        this.unitJointWrench = wrench;
        this.jointWrench = MecanoFactories.newWrenchReadOnly(this::getTau, this.unitJointWrench);
    }

    @Override
    public void setQ(double q) {
        this.q = q;
    }

    @Override
    public void setQd(double qd) {
        this.qd = qd;
    }

    @Override
    public void setQdd(double qdd) {
        this.qdd = qdd;
    }

    @Override
    public void setTau(double tau) {
        this.tau = tau;
    }

    @Override
    public void setJointLimitLower(double jointLimitLower) {
        this.jointLimitLower = jointLimitLower;
    }

    @Override
    public void setJointLimitUpper(double jointLimitUpper) {
        this.jointLimitUpper = jointLimitUpper;
    }

    @Override
    public void setVelocityLimitLower(double velocityLimitLower) {
        this.velocityLimitLower = velocityLimitLower;
    }

    @Override
    public void setVelocityLimitUpper(double velocityLimitUpper) {
        this.velocityLimitUpper = velocityLimitUpper;
    }

    @Override
    public void setEffortLimitLower(double effortLimitLower) {
        this.effortLimitLower = effortLimitLower;
    }

    @Override
    public void setEffortLimitUpper(double effortLimitUpper) {
        this.effortLimitUpper = effortLimitUpper;
    }

    @Override
    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public TwistReadOnly getUnitJointTwist() {
        return this.unitJointTwist;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    @Override
    public TwistReadOnly getUnitSuccessorTwist() {
        return this.unitSuccessorTwist;
    }

    @Override
    public TwistReadOnly getUnitPredecessorTwist() {
        return this.unitPredecessorTwist;
    }

    @Override
    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitJointAcceleration() {
        return this.unitJointAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration() {
        return this.unitSuccessorAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration() {
        return this.unitPredecessorAcceleration;
    }

    @Override
    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public double getQ() {
        return this.q;
    }

    @Override
    public double getQd() {
        return this.qd;
    }

    @Override
    public double getQdd() {
        return this.qdd;
    }

    @Override
    public double getTau() {
        return this.tau;
    }

    @Override
    public double getJointLimitLower() {
        return this.jointLimitLower;
    }

    @Override
    public double getJointLimitUpper() {
        return this.jointLimitUpper;
    }

    @Override
    public double getVelocityLimitLower() {
        return this.velocityLimitLower;
    }

    @Override
    public double getVelocityLimitUpper() {
        return this.velocityLimitUpper;
    }

    @Override
    public double getEffortLimitLower() {
        return this.effortLimitLower;
    }

    @Override
    public double getEffortLimitUpper() {
        return this.effortLimitUpper;
    }

    @Override
    public String toString() {
        String qAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQ());
        String qdAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQd());
        String qddAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQdd());
        String tauAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getTau());
        return super.toString() + ", q: " + qAsString + ", qd: " + qdAsString + ", qdd: " + qddAsString + ", tau: " + tauAsString;
    }
}

