/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.frames;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;

public class MovingCenterOfMassReferenceFrame
extends MovingReferenceFrame {
    private final CenterOfMassJacobian centerOfMassJacobian;

    public MovingCenterOfMassReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyReadOnly rootBody) {
        this(frameName, new CenterOfMassJacobian(rootBody, parentFrame));
    }

    public MovingCenterOfMassReferenceFrame(String frameName, CenterOfMassJacobian centerOfMassJacobian) {
        super(frameName, centerOfMassJacobian.getReferenceFrame());
        this.centerOfMassJacobian = centerOfMassJacobian;
    }

    @Override
    public void update() {
        this.centerOfMassJacobian.reset();
        super.update();
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        transformToParent.setTranslationAndIdentityRotation((Tuple3DReadOnly)this.centerOfMassJacobian.getCenterOfMass());
    }

    @Override
    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        twistRelativeToParentToPack.setToZero(this, this.getParent(), this);
        twistRelativeToParentToPack.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)this.centerOfMassJacobian.getCenterOfMassVelocity());
    }
}

