/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.Random;
import java.util.stream.IntStream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialImpulse;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.tools.MecanoTools;

public class MecanoRandomTools {
    public static MovingReferenceFrame nextMovingReferenceFrame(Random random) {
        return MecanoRandomTools.nextMovingReferenceFrame(random, false);
    }

    public static MovingReferenceFrame nextMovingReferenceFrame(Random random, boolean use2DTransform) {
        return MecanoRandomTools.nextMovingReferenceFrame(random, ReferenceFrame.getWorldFrame(), use2DTransform);
    }

    public static MovingReferenceFrame nextMovingReferenceFrame(Random random, ReferenceFrame parentFrame) {
        return MecanoRandomTools.nextMovingReferenceFrame(random, parentFrame, false);
    }

    public static MovingReferenceFrame nextMovingReferenceFrame(Random random, ReferenceFrame parentFrame, boolean use2DTransform) {
        return MecanoRandomTools.nextMovingReferenceFrame("randomFrame" + random.nextInt(), random, parentFrame, use2DTransform);
    }

    public static MovingReferenceFrame nextMovingReferenceFrame(String frameName, Random random, ReferenceFrame parentFrame) {
        return MecanoRandomTools.nextMovingReferenceFrame(frameName, random, parentFrame, false);
    }

    public static MovingReferenceFrame nextMovingReferenceFrame(String frameName, Random random, ReferenceFrame parentFrame, boolean use2DTransform) {
        RigidBodyTransform transform;
        final Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        final Vector3D linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        if (use2DTransform) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform2D((Random)random);
            angularVelocity.setX(0.0);
            angularVelocity.setY(0.0);
            linearVelocity.setZ(0.0);
        } else {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        }
        return new MovingReferenceFrame(frameName, parentFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(transform);
            }

            @Override
            protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
                twistRelativeToParentToPack.set((Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
            }
        };
    }

    public static MovingReferenceFrame[] nextMovingReferenceFrameTree(Random random) {
        return MecanoRandomTools.nextMovingReferenceFrameTree(random, false);
    }

    public static MovingReferenceFrame[] nextMovingReferenceFrameTree(Random random, boolean use2DTransforms) {
        return MecanoRandomTools.nextMovingReferenceFrameTree(random, 20, use2DTransforms);
    }

    public static MovingReferenceFrame[] nextMovingReferenceFrameTree(Random random, int numberOfMovingReferenceFrames) {
        return MecanoRandomTools.nextMovingReferenceFrameTree(random, numberOfMovingReferenceFrames, false);
    }

    public static MovingReferenceFrame[] nextMovingReferenceFrameTree(Random random, int numberOfMovingReferenceFrames, boolean use2DTransforms) {
        return MecanoRandomTools.nextMovingReferenceFrameTree("randomFrame", random, ReferenceFrame.getWorldFrame(), numberOfMovingReferenceFrames, use2DTransforms);
    }

    public static MovingReferenceFrame[] nextMovingReferenceFrameTree(String frameNamePrefix, Random random, ReferenceFrame rootFrame, int numberOfMovingReferenceFrames) {
        return MecanoRandomTools.nextMovingReferenceFrameTree(frameNamePrefix, random, rootFrame, numberOfMovingReferenceFrames, false);
    }

    public static MovingReferenceFrame[] nextMovingReferenceFrameTree(String frameNamePrefix, Random random, ReferenceFrame rootFrame, int numberOfMovingReferenceFrames, boolean use2DTransforms) {
        ReferenceFrame[] referenceFrames = new ReferenceFrame[numberOfMovingReferenceFrames + 1];
        MovingReferenceFrame[] movingReferenceFrames = new MovingReferenceFrame[numberOfMovingReferenceFrames];
        referenceFrames[0] = rootFrame;
        for (int i = 0; i < numberOfMovingReferenceFrames; ++i) {
            int parentFrameIndex = random.nextInt(i + 1);
            ReferenceFrame parentFrame = referenceFrames[parentFrameIndex];
            MovingReferenceFrame nextMovingReferenceFrame = MecanoRandomTools.nextMovingReferenceFrame(frameNamePrefix + i, random, parentFrame, use2DTransforms);
            referenceFrames[i + 1] = nextMovingReferenceFrame;
            movingReferenceFrames[i] = nextMovingReferenceFrame;
        }
        return movingReferenceFrames;
    }

    public static Vector3D[] nextVector3DArray(Random random, int arrayLength, double vectorsLength) {
        return (Vector3D[])IntStream.range(0, arrayLength).mapToObj(i -> EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)vectorsLength)).toArray(Vector3D[]::new);
    }

    public static SpatialVector nextSpatialVector(Random random, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextSpatialVector(random, expressedInFrame, 1.0, 1.0);
    }

    public static SpatialVector nextSpatialVector(Random random, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new SpatialVector(expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax));
    }

    public static SpatialForce nextSpatialForce(Random random, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextSpatialForce(random, expressedInFrame, 1.0, 1.0);
    }

    public static SpatialForce nextSpatialForce(Random random, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new SpatialForce(expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax));
    }

    public static Wrench nextWrench(Random random, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextWrench(random, bodyFrame, expressedInFrame, 1.0, 1.0);
    }

    public static Wrench nextWrench(Random random, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new Wrench(bodyFrame, expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax));
    }

    public static SpatialImpulse nextSpatialImpulse(Random random, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextSpatialImpulse(random, bodyFrame, expressedInFrame, 1.0, 1.0);
    }

    public static SpatialImpulse nextSpatialImpulse(Random random, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new SpatialImpulse(bodyFrame, expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax));
    }

    public static Twist nextTwist(Random random, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextTwist(random, bodyFrame, baseFrame, expressedInFrame, 1.0, 1.0);
    }

    public static Twist nextTwist(Random random, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new Twist(bodyFrame, baseFrame, expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax));
    }

    public static SpatialAcceleration nextSpatialAcceleration(Random random, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextSpatialAcceleration(random, bodyFrame, baseFrame, expressedInFrame, 1.0, 1.0);
    }

    public static SpatialAcceleration nextSpatialAcceleration(Random random, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new SpatialAcceleration(bodyFrame, baseFrame, expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax));
    }

    public static Momentum nextMomentum(Random random, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextMomentum(random, expressedInFrame, 1.0, 1.0);
    }

    public static Momentum nextMomentum(Random random, ReferenceFrame expressedInFrame, double angularPartMinMax, double linearPartMinMax) {
        return new Momentum(expressedInFrame, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-angularPartMinMax), (double)angularPartMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-linearPartMinMax), (double)linearPartMinMax));
    }

    public static SpatialInertia nextSpatialInertia(Random random, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        return MecanoRandomTools.nextSpatialInertia(random, bodyFrame, expressedInFrame, 1.0, 1.0, 1.0);
    }

    public static SpatialInertia nextSpatialInertia(Random random, ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double inertiaMax, double massMax, double centerOfMassOffsetMinMax) {
        if (inertiaMax < 0.0) {
            throw new IllegalArgumentException("The inertia cannot be negative.");
        }
        if (massMax < 0.0) {
            throw new IllegalArgumentException("The mass cannot be negative.");
        }
        return new SpatialInertia(bodyFrame, expressedInFrame, (Matrix3DReadOnly)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)0.0, (double)inertiaMax), massMax * random.nextDouble(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerOfMassOffsetMinMax));
    }

    public static Matrix3D nextSymmetricPositiveDefiniteMatrix3D(Random random) {
        return MecanoRandomTools.nextSymmetricPositiveDefiniteMatrix3D(random, 1.0E-6, 2.0, 0.5);
    }

    public static Matrix3D nextSymmetricPositiveDefiniteMatrix3D(Random random, double minDiagonal, double maxDiagonal, double minMaxOffDiagonal) {
        if (minDiagonal < 0.0) {
            throw new RuntimeException("minDiagonal has to be positive.");
        }
        Matrix3D lowerTriangular = new Matrix3D();
        lowerTriangular.setM00(EuclidCoreRandomTools.nextDouble((Random)random, (double)minDiagonal, (double)maxDiagonal));
        lowerTriangular.setM10(EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxOffDiagonal));
        lowerTriangular.setM11(EuclidCoreRandomTools.nextDouble((Random)random, (double)minDiagonal, (double)maxDiagonal));
        lowerTriangular.setM20(EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxOffDiagonal));
        lowerTriangular.setM21(EuclidCoreRandomTools.nextDouble((Random)random, (double)minMaxOffDiagonal));
        lowerTriangular.setM22(EuclidCoreRandomTools.nextDouble((Random)random, (double)minDiagonal, (double)maxDiagonal));
        Matrix3D symmetricPositiveDefiniteMatrix3D = new Matrix3D((Matrix3DReadOnly)lowerTriangular);
        symmetricPositiveDefiniteMatrix3D.multiplyTransposeOther((Matrix3DReadOnly)lowerTriangular);
        MecanoTools.checkIfMatrix3DIsSymmetric((Matrix3DReadOnly)symmetricPositiveDefiniteMatrix3D, 1.0E-8);
        MecanoRandomTools.checkEigenValuesRealAndPositive(symmetricPositiveDefiniteMatrix3D, 1.0E-10);
        return symmetricPositiveDefiniteMatrix3D;
    }

    private static void checkEigenValuesRealAndPositive(Matrix3D matrix, double epsilon) {
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        matrix.get((DMatrix)denseMatrix);
        EigenDecomposition_F64 eig = DecompositionFactory_DDRM.eig((int)3, (boolean)false);
        eig.decompose((Matrix)denseMatrix);
        for (int i = 0; i < eig.getNumberOfEigenvalues(); ++i) {
            double eigImaginaryPart = eig.getEigenvalue(i).getImaginary();
            double eigRealPart = eig.getEigenvalue(i).getReal();
            if (!EuclidCoreTools.epsilonEquals((double)0.0, (double)eigImaginaryPart, (double)epsilon)) {
                throw new RuntimeException("The matrix has at least one imaginary eigen value.");
            }
            if (!(eigRealPart <= 0.0)) continue;
            throw new RuntimeException("The matrix has at least one non-positive eigen value.");
        }
    }
}

