/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface PlanarJointBasics
extends PlanarJointReadOnly,
FloatingJointBasics {
    @Override
    default public void setJointConfiguration(JointReadOnly other) {
        this.setJointConfiguration(MecanoTools.checkTypeAndCast(other, PlanarJointReadOnly.class));
    }

    default public void setJointConfiguration(PlanarJointReadOnly other) {
        this.setJointConfiguration(other.getJointPose());
    }

    @Override
    default public void setJointTwist(JointReadOnly other) {
        this.setJointTwist(MecanoTools.checkTypeAndCast(other, PlanarJointReadOnly.class));
    }

    default public void setJointTwist(PlanarJointReadOnly other) {
        FrameVector3DReadOnly otherAngularVelocity = other.getJointTwist().getAngularPart();
        FrameVector3DReadOnly otherLinearVelocity = other.getJointTwist().getLinearPart();
        this.setJointAngularVelocity((Vector3DReadOnly)otherAngularVelocity);
        this.setJointLinearVelocity((Vector3DReadOnly)otherLinearVelocity);
    }

    @Override
    default public void setJointAcceleration(JointReadOnly other) {
        this.setJointAcceleration(MecanoTools.checkTypeAndCast(other, PlanarJointReadOnly.class));
    }

    default public void setJointAcceleration(PlanarJointReadOnly other) {
        FrameVector3DReadOnly otherAngularAcceleration = other.getJointAcceleration().getAngularPart();
        FrameVector3DReadOnly otherLinearAcceleration = other.getJointAcceleration().getLinearPart();
        this.setJointAngularAcceleration((Vector3DReadOnly)otherAngularAcceleration);
        this.setJointLinearAcceleration((Vector3DReadOnly)otherLinearAcceleration);
    }

    @Override
    default public void setJointWrench(JointReadOnly other) {
        this.setJointWrench(MecanoTools.checkTypeAndCast(other, PlanarJointReadOnly.class));
    }

    default public void setJointWrench(PlanarJointReadOnly other) {
        FrameVector3DReadOnly otherTorque = other.getJointWrench().getAngularPart();
        FrameVector3DReadOnly otherForce = other.getJointWrench().getLinearPart();
        this.setJointTorque((Vector3DReadOnly)otherTorque);
        this.setJointForce((Vector3DReadOnly)otherForce);
    }

    @Override
    default public int setJointConfiguration(int rowStart, DMatrix matrix) {
        int index = rowStart;
        double qRot = matrix.get(index++, 0);
        double x = matrix.get(index++, 0);
        double z = matrix.get(index++, 0);
        this.getJointPose().getOrientation().setToPitchOrientation(qRot);
        this.getJointPose().getPosition().set(x, 0.0, z);
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int setJointVelocity(int rowStart, DMatrix matrix) {
        int index = rowStart;
        double qdRot = matrix.get(index++, 0);
        double xd = matrix.get(index++, 0);
        double zd = matrix.get(index++, 0);
        this.getJointTwist().setToZero();
        this.getJointTwist().setAngularPartY(qdRot);
        this.getJointTwist().getLinearPart().set(xd, 0.0, zd);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointAcceleration(int rowStart, DMatrix matrix) {
        this.getJointAcceleration().setToZero();
        this.getJointAcceleration().setAngularPartY(matrix.get(rowStart + 0, 0));
        this.getJointAcceleration().setLinearPartX(matrix.get(rowStart + 1, 0));
        this.getJointAcceleration().setLinearPartZ(matrix.get(rowStart + 2, 0));
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointTau(int rowStart, DMatrix matrix) {
        this.getJointWrench().setToZero();
        this.getJointWrench().setAngularPartY(matrix.get(rowStart + 0, 0));
        this.getJointWrench().setLinearPartX(matrix.get(rowStart + 1, 0));
        this.getJointWrench().setLinearPartZ(matrix.get(rowStart + 2, 0));
        return rowStart + this.getDegreesOfFreedom();
    }
}

