/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class MecanoTools {
    public static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1, string.length());
    }

    @Deprecated
    public static double tuple3DDotProduct(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        return TupleTools.dot((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2);
    }

    public static boolean isMatrix3DSymmetric(Matrix3DReadOnly matrixToTest, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals((double)0.0, (double)(matrixToTest.getM01() - matrixToTest.getM10()), (double)epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals((double)0.0, (double)(matrixToTest.getM02() - matrixToTest.getM20()), (double)epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)0.0, (double)(matrixToTest.getM12() - matrixToTest.getM21()), (double)epsilon);
    }

    public static boolean isMatrix3DDiagonal(Matrix3DReadOnly matrixToTest, double epsilon) {
        return MecanoTools.isMatrix3DDiagonal(matrixToTest.getM00(), matrixToTest.getM01(), matrixToTest.getM02(), matrixToTest.getM10(), matrixToTest.getM11(), matrixToTest.getM12(), matrixToTest.getM20(), matrixToTest.getM21(), matrixToTest.getM22(), epsilon);
    }

    public static boolean isMatrix3DDiagonal(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, double epsilon) {
        return Math.abs(m01) <= epsilon && Math.abs(m02) <= epsilon && Math.abs(m12) <= epsilon && Math.abs(m10) <= epsilon && Math.abs(m20) <= epsilon && Math.abs(m21) <= epsilon;
    }

    public static void checkIfMatrix3DIsSymmetric(Matrix3DReadOnly matrixToTest, double epsilon) {
        if (!MecanoTools.isMatrix3DSymmetric(matrixToTest, epsilon)) {
            throw new RuntimeException("The matrix is not symmetric:\n" + matrixToTest.toString());
        }
    }

    @Deprecated
    public static void checkMatrixMinimumSize(int minRows, int minColumns, DMatrix matrixToTest) {
        EuclidCoreTools.checkMatrixMinimumSize((int)minRows, (int)minColumns, (Matrix)matrixToTest);
    }

    public static void addCrossToVector(Tuple3DReadOnly crossTerm1, Tuple3DReadOnly crossTerm2, Vector3DBasics vectorToModify) {
        double tempX = vectorToModify.getX();
        double tempY = vectorToModify.getY();
        double tempZ = vectorToModify.getZ();
        vectorToModify.cross(crossTerm1, crossTerm2);
        vectorToModify.add(tempX, tempY, tempZ);
    }

    public static void toTildeForm(Tuple3DReadOnly tuple, int startRow, int startColumn, DMatrix matrixToPack) {
        MecanoTools.toTildeForm(tuple, false, startRow, startColumn, matrixToPack);
    }

    public static void toTildeForm(Tuple3DReadOnly tuple, boolean transpose, int startRow, int startColumn, DMatrix matrixToPack) {
        MecanoTools.toTildeForm(1.0, tuple, transpose, startRow, startColumn, matrixToPack);
    }

    public static void toTildeForm(double scale, Tuple3DReadOnly tuple, boolean transpose, int startRow, int startColumn, DMatrix matrixToPack) {
        double z;
        double y;
        double x;
        if (transpose) {
            x = -scale * tuple.getX();
            y = -scale * tuple.getY();
            z = -scale * tuple.getZ();
        } else {
            x = scale * tuple.getX();
            y = scale * tuple.getY();
            z = scale * tuple.getZ();
        }
        int row = startRow;
        matrixToPack.set(row, startColumn, 0.0);
        matrixToPack.set(row, startColumn + 1, -z);
        matrixToPack.set(row, startColumn + 2, y);
        matrixToPack.set(++row, startColumn, z);
        matrixToPack.set(row, startColumn + 1, 0.0);
        matrixToPack.set(row, startColumn + 2, -x);
        matrixToPack.set(++row, startColumn, -y);
        matrixToPack.set(row, startColumn + 1, x);
        matrixToPack.set(row, startColumn + 2, 0.0);
    }

    public static void addEquals(int startRow, int startColumn, DMatrix matrixToAdd, Matrix3DBasics matrixToModify) {
        int row = startRow;
        double m00 = matrixToModify.getM00() + matrixToAdd.get(row, startColumn);
        double m01 = matrixToModify.getM01() + matrixToAdd.get(row, startColumn + 1);
        double m02 = matrixToModify.getM02() + matrixToAdd.get(row, startColumn + 2);
        double m10 = matrixToModify.getM10() + matrixToAdd.get(++row, startColumn);
        double m11 = matrixToModify.getM11() + matrixToAdd.get(row, startColumn + 1);
        double m12 = matrixToModify.getM12() + matrixToAdd.get(row, startColumn + 2);
        double m20 = matrixToModify.getM20() + matrixToAdd.get(++row, startColumn);
        double m21 = matrixToModify.getM21() + matrixToAdd.get(row, startColumn + 1);
        double m22 = matrixToModify.getM22() + matrixToAdd.get(row, startColumn + 2);
        matrixToModify.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void subEquals(int startRow, int startColumn, DMatrix matrixToAdd, Matrix3DBasics matrixToModify) {
        int row = startRow;
        double m00 = matrixToModify.getM00() - matrixToAdd.get(row, startColumn);
        double m01 = matrixToModify.getM01() - matrixToAdd.get(row, startColumn + 1);
        double m02 = matrixToModify.getM02() - matrixToAdd.get(row, startColumn + 2);
        double m10 = matrixToModify.getM10() - matrixToAdd.get(++row, startColumn);
        double m11 = matrixToModify.getM11() - matrixToAdd.get(row, startColumn + 1);
        double m12 = matrixToModify.getM12() - matrixToAdd.get(row, startColumn + 2);
        double m20 = matrixToModify.getM20() - matrixToAdd.get(++row, startColumn);
        double m21 = matrixToModify.getM21() - matrixToAdd.get(row, startColumn + 1);
        double m22 = matrixToModify.getM22() - matrixToAdd.get(row, startColumn + 2);
        matrixToModify.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void translateMomentOfInertia(double mass, Tuple3DReadOnly centerOfMass, boolean negateTranslation, Tuple3DReadOnly translation, Matrix3DBasics momentOfInertiaToTransform) {
        double tyz;
        double txz;
        double txy;
        double tzz;
        double tyy;
        double txx;
        double xp = translation.getX();
        double yp = translation.getY();
        double zp = translation.getZ();
        if (negateTranslation) {
            xp = -xp;
            yp = -yp;
            zp = -zp;
        }
        double xp_xp = xp * xp;
        double yp_yp = yp * yp;
        double zp_zp = zp * zp;
        if (centerOfMass != null) {
            double xc = centerOfMass.getX();
            double yc = centerOfMass.getY();
            double zc = centerOfMass.getZ();
            double two_xc_xp = 2.0 * xc * xp;
            double two_yc_yp = 2.0 * yc * yp;
            double two_zc_zp = 2.0 * zc * zp;
            txx = mass * (two_yc_yp + two_zc_zp + yp_yp + zp_zp);
            tyy = mass * (two_xc_xp + two_zc_zp + xp_xp + zp_zp);
            tzz = mass * (two_xc_xp + two_yc_yp + xp_xp + yp_yp);
            txy = mass * (-xc * yp - yc * xp - xp * yp);
            txz = mass * (-xc * zp - zc * xp - xp * zp);
            tyz = mass * (-yc * zp - zc * yp - yp * zp);
        } else {
            txx = mass * (yp_yp + zp_zp);
            tyy = mass * (xp_xp + zp_zp);
            tzz = mass * (xp_xp + yp_yp);
            txy = -mass * xp * yp;
            txz = -mass * xp * zp;
            tyz = -mass * yp * zp;
        }
        double m00 = momentOfInertiaToTransform.getM00() + txx;
        double m01 = momentOfInertiaToTransform.getM01() + txy;
        double m02 = momentOfInertiaToTransform.getM02() + txz;
        double m10 = momentOfInertiaToTransform.getM10() + txy;
        double m11 = momentOfInertiaToTransform.getM11() + tyy;
        double m12 = momentOfInertiaToTransform.getM12() + tyz;
        double m20 = momentOfInertiaToTransform.getM20() + txz;
        double m21 = momentOfInertiaToTransform.getM21() + tyz;
        double m22 = momentOfInertiaToTransform.getM22() + tzz;
        momentOfInertiaToTransform.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static void computeDynamicMomentFast(Matrix3DReadOnly momentOfInertia, Vector3DReadOnly angularAcceleration, Vector3DReadOnly angularVelocity, Vector3DBasics dynamicMomentToPack) {
        if (angularVelocity == null) {
            dynamicMomentToPack.setToZero();
        } else {
            momentOfInertia.transform((Tuple3DReadOnly)angularVelocity, (Tuple3DBasics)dynamicMomentToPack);
            dynamicMomentToPack.cross((Tuple3DReadOnly)angularVelocity, (Tuple3DReadOnly)dynamicMomentToPack);
        }
        if (angularAcceleration != null) {
            double mx = dynamicMomentToPack.getX();
            double my = dynamicMomentToPack.getY();
            double mz = dynamicMomentToPack.getZ();
            momentOfInertia.transform((Tuple3DReadOnly)angularAcceleration, (Tuple3DBasics)dynamicMomentToPack);
            dynamicMomentToPack.add(mx, my, mz);
        }
    }

    public static void computeDynamicMoment(Matrix3DReadOnly momentOfInertia, double mass, Vector3DReadOnly centerOfMassOffset, Vector3DReadOnly angularAcceleration, Vector3DReadOnly linearAcceleration, Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity, Vector3DBasics dynamicMomentToPack) {
        double mz;
        double my;
        double mx;
        if (linearAcceleration == null) {
            dynamicMomentToPack.setToZero();
        } else {
            dynamicMomentToPack.cross((Tuple3DReadOnly)centerOfMassOffset, (Tuple3DReadOnly)linearAcceleration);
        }
        if (angularVelocity != null) {
            if (linearVelocity != null) {
                double omega_dot_c = angularVelocity.dot((Tuple3DReadOnly)centerOfMassOffset);
                double v_dot_c = linearVelocity.dot((Tuple3DReadOnly)centerOfMassOffset);
                dynamicMomentToPack.addX(angularVelocity.getX() * v_dot_c - linearVelocity.getX() * omega_dot_c);
                dynamicMomentToPack.addY(angularVelocity.getY() * v_dot_c - linearVelocity.getY() * omega_dot_c);
                dynamicMomentToPack.addZ(angularVelocity.getZ() * v_dot_c - linearVelocity.getZ() * omega_dot_c);
                dynamicMomentToPack.scale(mass);
            }
            mx = dynamicMomentToPack.getX();
            my = dynamicMomentToPack.getY();
            mz = dynamicMomentToPack.getZ();
            momentOfInertia.transform((Tuple3DReadOnly)angularVelocity, (Tuple3DBasics)dynamicMomentToPack);
            dynamicMomentToPack.cross((Tuple3DReadOnly)angularVelocity, (Tuple3DReadOnly)dynamicMomentToPack);
            mx += dynamicMomentToPack.getX();
            my += dynamicMomentToPack.getY();
            mz += dynamicMomentToPack.getZ();
        } else {
            mx = dynamicMomentToPack.getX();
            my = dynamicMomentToPack.getY();
            mz = dynamicMomentToPack.getZ();
        }
        if (angularAcceleration != null) {
            momentOfInertia.transform((Tuple3DReadOnly)angularAcceleration, (Tuple3DBasics)dynamicMomentToPack);
            dynamicMomentToPack.add(mx, my, mz);
        } else {
            dynamicMomentToPack.set(mx, my, mz);
        }
    }

    public static void computeDynamicForceFast(double mass, Vector3DReadOnly linearAcceleration, Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity, Vector3DBasics dynamicForceToPack) {
        if (angularVelocity != null && linearVelocity != null) {
            dynamicForceToPack.cross((Tuple3DReadOnly)angularVelocity, (Tuple3DReadOnly)linearVelocity);
            if (linearAcceleration != null) {
                dynamicForceToPack.add((Tuple3DReadOnly)linearAcceleration);
            }
            dynamicForceToPack.scale(mass);
        } else {
            dynamicForceToPack.setToZero();
            if (linearAcceleration != null) {
                dynamicForceToPack.add((Tuple3DReadOnly)linearAcceleration);
                dynamicForceToPack.scale(mass);
            }
        }
    }

    public static void computeDynamicForce(double mass, Vector3DReadOnly centerOfMassOffset, Vector3DReadOnly angularAcceleration, Vector3DReadOnly linearAcceleration, Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity, Vector3DBasics dynamicForceToPack) {
        if (angularVelocity != null) {
            dynamicForceToPack.cross((Tuple3DReadOnly)centerOfMassOffset, (Tuple3DReadOnly)angularVelocity);
            if (linearVelocity != null) {
                dynamicForceToPack.sub((Tuple3DReadOnly)linearVelocity);
            }
            dynamicForceToPack.cross((Tuple3DReadOnly)angularVelocity, (Tuple3DReadOnly)dynamicForceToPack);
        } else {
            dynamicForceToPack.setToZero();
        }
        if (angularAcceleration != null) {
            MecanoTools.addCrossToVector((Tuple3DReadOnly)centerOfMassOffset, (Tuple3DReadOnly)angularAcceleration, dynamicForceToPack);
        }
        dynamicForceToPack.negate();
        if (linearAcceleration != null) {
            dynamicForceToPack.add((Tuple3DReadOnly)linearAcceleration);
        }
        dynamicForceToPack.scale(mass);
    }

    public static double computeKineticCoEnergy(Matrix3DReadOnly momentOfInertia, double mass, Vector3DReadOnly centerOfMassOffset, Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity) {
        double energy = mass * linearVelocity.lengthSquared();
        double cx = centerOfMassOffset.getX();
        double cy = centerOfMassOffset.getY();
        double cz = centerOfMassOffset.getZ();
        double wx = angularVelocity.getX();
        double wy = angularVelocity.getY();
        double wz = angularVelocity.getZ();
        double vx = linearVelocity.getX();
        double vy = linearVelocity.getY();
        double vz = linearVelocity.getZ();
        double ixx = momentOfInertia.getM00();
        double iyy = momentOfInertia.getM11();
        double izz = momentOfInertia.getM22();
        double ixy = momentOfInertia.getM01();
        double ixz = momentOfInertia.getM02();
        double iyz = momentOfInertia.getM12();
        double iyx = momentOfInertia.getM10();
        double izx = momentOfInertia.getM20();
        double izy = momentOfInertia.getM21();
        double c_cross_v_x = cy * vz - cz * vy;
        double c_cross_v_y = cz * vx - cx * vz;
        double c_cross_v_z = cx * vy - cy * vx;
        energy += 2.0 * mass * (wx * c_cross_v_x + wy * c_cross_v_y + wz * c_cross_v_z);
        double j_w_x = ixx * wx + ixy * wy + ixz * wz;
        double j_w_y = iyx * wx + iyy * wy + iyz * wz;
        double j_w_z = izx * wx + izy * wy + izz * wz;
        return 0.5 * (energy += wx * j_w_x + wy * j_w_y + wz * j_w_z);
    }

    public static <T extends JointReadOnly> T checkTypeAndCast(JointReadOnly jointToCast, Class<T> classToCastTo) {
        if (classToCastTo.isInstance(jointToCast)) {
            return (T)jointToCast;
        }
        throw new RuntimeException("Cannot cast " + jointToCast.getClass().getSimpleName() + " to " + classToCastTo.getSimpleName());
    }

    public static List<TwistReadOnly> computePlanarJointMotionSubspace(ReferenceFrame beforeJointFrame, ReferenceFrame afterJointFrame) {
        int nDegreesOfFreedom = 3;
        RigidBodyTransform identity = new RigidBodyTransform();
        ReferenceFrame[] intermediateFrames = new ReferenceFrame[nDegreesOfFreedom];
        intermediateFrames[nDegreesOfFreedom - 1] = afterJointFrame;
        for (int dofIndex = intermediateFrames.length - 2; dofIndex >= 0; --dofIndex) {
            ReferenceFrame parentFrame = intermediateFrames[dofIndex + 1];
            String frameName = "intermediateFrame" + dofIndex;
            intermediateFrames[dofIndex] = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)identity);
        }
        ArrayList<Twist> unitTwistsInBodyFrame = new ArrayList<Twist>();
        ReferenceFrame previousFrame = beforeJointFrame;
        int[] twistComponentIndex = new int[]{1, 3, 5};
        for (int dofIndex = 0; dofIndex < nDegreesOfFreedom; ++dofIndex) {
            ReferenceFrame frame = intermediateFrames[dofIndex];
            Twist twist = new Twist(frame, previousFrame, frame);
            twist.setElement(twistComponentIndex[dofIndex], 1.0);
            unitTwistsInBodyFrame.add(twist);
            previousFrame = frame;
        }
        return Collections.unmodifiableList(unitTwistsInBodyFrame);
    }

    public static List<TwistReadOnly> computeSixDoFJointMotionSubspace(ReferenceFrame beforeJointFrame, ReferenceFrame afterJointFrame) {
        int nDegreesOfFreedom = 6;
        RigidBodyTransform identity = new RigidBodyTransform();
        ReferenceFrame[] intermediateFrames = new ReferenceFrame[nDegreesOfFreedom];
        intermediateFrames[nDegreesOfFreedom - 1] = afterJointFrame;
        for (int dofIndex = intermediateFrames.length - 2; dofIndex >= 0; --dofIndex) {
            ReferenceFrame parentFrame = intermediateFrames[dofIndex + 1];
            String frameName = "intermediateFrame" + dofIndex;
            intermediateFrames[dofIndex] = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)identity);
        }
        ArrayList<Twist> unitTwistsInBodyFrame = new ArrayList<Twist>();
        ReferenceFrame previousFrame = beforeJointFrame;
        for (int dofIndex = 0; dofIndex < nDegreesOfFreedom; ++dofIndex) {
            ReferenceFrame frame = intermediateFrames[dofIndex];
            Twist twist = new Twist(frame, previousFrame, frame);
            twist.setElement(dofIndex, 1.0);
            unitTwistsInBodyFrame.add(twist);
            previousFrame = frame;
        }
        return Collections.unmodifiableList(unitTwistsInBodyFrame);
    }

    public static List<TwistReadOnly> computeSphericalJointMotionSubspace(ReferenceFrame beforeJointFrame, ReferenceFrame afterJointFrame) {
        int nDegreesOfFreedom = 3;
        RigidBodyTransform identity = new RigidBodyTransform();
        ReferenceFrame[] intermediateFrames = new ReferenceFrame[nDegreesOfFreedom];
        intermediateFrames[nDegreesOfFreedom - 1] = afterJointFrame;
        for (int dofIndex = intermediateFrames.length - 2; dofIndex >= 0; --dofIndex) {
            ReferenceFrame parentFrame = intermediateFrames[dofIndex + 1];
            String frameName = "intermediateFrame" + dofIndex;
            intermediateFrames[dofIndex] = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)identity);
        }
        ArrayList<Twist> unitTwistsInBodyFrame = new ArrayList<Twist>();
        ReferenceFrame previousFrame = beforeJointFrame;
        for (int dofIndex = 0; dofIndex < nDegreesOfFreedom; ++dofIndex) {
            ReferenceFrame frame = intermediateFrames[dofIndex];
            Twist twist = new Twist(frame, previousFrame, frame);
            twist.setElement(dofIndex, 1.0);
            unitTwistsInBodyFrame.add(twist);
            previousFrame = frame;
        }
        return Collections.unmodifiableList(unitTwistsInBodyFrame);
    }

    public static void transformSymmetricMatrix3D(RotationMatrixReadOnly rotation, Matrix3DBasics symmetricMatrixToRotate) {
        Matrix3DTools.multiply((Matrix3DReadOnly)rotation, (Matrix3DReadOnly)symmetricMatrixToRotate, (CommonMatrix3DBasics)symmetricMatrixToRotate);
        double m00 = symmetricMatrixToRotate.getM00() * rotation.getM00() + symmetricMatrixToRotate.getM01() * rotation.getM01() + symmetricMatrixToRotate.getM02() * rotation.getM02();
        double m01 = symmetricMatrixToRotate.getM00() * rotation.getM10() + symmetricMatrixToRotate.getM01() * rotation.getM11() + symmetricMatrixToRotate.getM02() * rotation.getM12();
        double m02 = symmetricMatrixToRotate.getM00() * rotation.getM20() + symmetricMatrixToRotate.getM01() * rotation.getM21() + symmetricMatrixToRotate.getM02() * rotation.getM22();
        double m11 = symmetricMatrixToRotate.getM10() * rotation.getM10() + symmetricMatrixToRotate.getM11() * rotation.getM11() + symmetricMatrixToRotate.getM12() * rotation.getM12();
        double m12 = symmetricMatrixToRotate.getM10() * rotation.getM20() + symmetricMatrixToRotate.getM11() * rotation.getM21() + symmetricMatrixToRotate.getM12() * rotation.getM22();
        double m22 = symmetricMatrixToRotate.getM20() * rotation.getM20() + symmetricMatrixToRotate.getM21() * rotation.getM21() + symmetricMatrixToRotate.getM22() * rotation.getM22();
        symmetricMatrixToRotate.set(m00, m01, m02, m01, m11, m12, m02, m12, m22);
    }

    public static void inverseTransformSymmetricMatrix3D(RotationMatrixReadOnly rotation, Matrix3DBasics symmetricMatrixToRotate) {
        Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)rotation, (Matrix3DReadOnly)symmetricMatrixToRotate, (CommonMatrix3DBasics)symmetricMatrixToRotate);
        double m00 = symmetricMatrixToRotate.getM00() * rotation.getM00() + symmetricMatrixToRotate.getM01() * rotation.getM10() + symmetricMatrixToRotate.getM02() * rotation.getM20();
        double m01 = symmetricMatrixToRotate.getM00() * rotation.getM01() + symmetricMatrixToRotate.getM01() * rotation.getM11() + symmetricMatrixToRotate.getM02() * rotation.getM21();
        double m02 = symmetricMatrixToRotate.getM00() * rotation.getM02() + symmetricMatrixToRotate.getM01() * rotation.getM12() + symmetricMatrixToRotate.getM02() * rotation.getM22();
        double m11 = symmetricMatrixToRotate.getM10() * rotation.getM01() + symmetricMatrixToRotate.getM11() * rotation.getM11() + symmetricMatrixToRotate.getM12() * rotation.getM21();
        double m12 = symmetricMatrixToRotate.getM10() * rotation.getM02() + symmetricMatrixToRotate.getM11() * rotation.getM12() + symmetricMatrixToRotate.getM12() * rotation.getM22();
        double m22 = symmetricMatrixToRotate.getM20() * rotation.getM02() + symmetricMatrixToRotate.getM21() * rotation.getM12() + symmetricMatrixToRotate.getM22() * rotation.getM22();
        symmetricMatrixToRotate.set(m00, m01, m02, m01, m11, m12, m02, m12, m22);
    }
}

