/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;

public interface FixedFrameSpatialInertiaBasics
extends SpatialInertiaReadOnly,
Clearable {
    public Matrix3DBasics getMomentOfInertia();

    public void setMass(double var1);

    public FixedFrameVector3DBasics getCenterOfMassOffset();

    @Override
    default public boolean containsNaN() {
        return SpatialInertiaReadOnly.super.containsNaN();
    }

    default public void setToZero() {
        this.getMomentOfInertia().setToZero();
        this.setMass(0.0);
        this.getCenterOfMassOffset().setToZero();
    }

    default public void setToNaN() {
        this.getMomentOfInertia().setToNaN();
        this.setMass(Double.NaN);
        this.getCenterOfMassOffset().setToNaN();
    }

    default public void setMomentOfInertia(double Ixx, double Iyy, double Izz) {
        this.getMomentOfInertia().set(Ixx, 0.0, 0.0, 0.0, Iyy, 0.0, 0.0, 0.0, Izz);
    }

    default public void set(SpatialInertiaReadOnly other) {
        this.checkReferenceFrameMatch(other);
        this.getMomentOfInertia().set(other.getMomentOfInertia());
        this.setMass(other.getMass());
        this.getCenterOfMassOffset().set((FrameTuple3DReadOnly)other.getCenterOfMassOffset());
    }

    default public void add(SpatialInertiaReadOnly other) {
        other.checkReferenceFrameMatch(this.getReferenceFrame());
        this.getMomentOfInertia().add(other.getMomentOfInertia());
        this.getCenterOfMassOffset().scale(this.getMass());
        this.getCenterOfMassOffset().scaleAdd(other.getMass(), (FrameTuple3DReadOnly)other.getCenterOfMassOffset(), (FrameTuple3DReadOnly)this.getCenterOfMassOffset());
        this.setMass(this.getMass() + other.getMass());
        if (Math.abs(this.getMass()) >= 1.0E-7) {
            this.getCenterOfMassOffset().scale(1.0 / this.getMass());
        }
    }
}

