/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoIOTools;

public class SpatialVector
implements SpatialVectorBasics {
    private ReferenceFrame expressedInFrame = ReferenceFrame.getWorldFrame();
    private final FixedFrameVector3DBasics angularPart = MecanoFactories.newFixedFrameVector3DBasics(this);
    private final FixedFrameVector3DBasics linearPart = MecanoFactories.newFixedFrameVector3DBasics(this);

    public SpatialVector() {
    }

    public SpatialVector(ReferenceFrame expressedInFrame) {
        this.setToZero(expressedInFrame);
    }

    public SpatialVector(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.setIncludingFrame(expressedInFrame, angularPart, linearPart);
    }

    public SpatialVector(FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        this.setIncludingFrame(angularPart, linearPart);
    }

    public SpatialVector(SpatialVectorReadOnly other) {
        this.setIncludingFrame(other);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.expressedInFrame;
    }

    @Override
    public FixedFrameVector3DBasics getAngularPart() {
        return this.angularPart;
    }

    @Override
    public FixedFrameVector3DBasics getLinearPart() {
        return this.linearPart;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.expressedInFrame = expressedInFrame;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialVectorReadOnly) {
            return SpatialVectorBasics.super.equals((SpatialVectorReadOnly)object);
        }
        return super.equals(object);
    }

    public String toString() {
        return MecanoIOTools.getSpatialVectorString(this);
    }
}

