/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface SixDoFJointBasics
extends SixDoFJointReadOnly,
FloatingJointBasics {
    @Override
    default public void setJointConfiguration(JointReadOnly other) {
        this.setJointConfiguration(MecanoTools.checkTypeAndCast(other, SixDoFJointReadOnly.class));
    }

    default public void setJointConfiguration(SixDoFJointReadOnly other) {
        this.setJointConfiguration(other.getJointPose());
    }

    @Override
    default public void setJointTwist(JointReadOnly other) {
        this.setJointTwist(MecanoTools.checkTypeAndCast(other, SixDoFJointReadOnly.class));
    }

    default public void setJointTwist(SixDoFJointReadOnly other) {
        FrameVector3DReadOnly otherAngularVelocity = other.getJointTwist().getAngularPart();
        FrameVector3DReadOnly otherLinearVelocity = other.getJointTwist().getLinearPart();
        this.setJointAngularVelocity((Vector3DReadOnly)otherAngularVelocity);
        this.setJointLinearVelocity((Vector3DReadOnly)otherLinearVelocity);
    }

    @Override
    default public void setJointAcceleration(JointReadOnly other) {
        this.setJointAcceleration(MecanoTools.checkTypeAndCast(other, SixDoFJointReadOnly.class));
    }

    default public void setJointAcceleration(SixDoFJointReadOnly other) {
        FrameVector3DReadOnly otherAngularAcceleration = other.getJointAcceleration().getAngularPart();
        FrameVector3DReadOnly otherLinearAcceleration = other.getJointAcceleration().getLinearPart();
        this.setJointAngularAcceleration((Vector3DReadOnly)otherAngularAcceleration);
        this.setJointLinearAcceleration((Vector3DReadOnly)otherLinearAcceleration);
    }

    @Override
    default public void setJointWrench(JointReadOnly other) {
        this.setJointWrench(MecanoTools.checkTypeAndCast(other, SixDoFJointReadOnly.class));
    }

    default public void setJointWrench(SixDoFJointReadOnly other) {
        FrameVector3DReadOnly otherTorque = other.getJointWrench().getAngularPart();
        FrameVector3DReadOnly otherForce = other.getJointWrench().getLinearPart();
        this.setJointTorque((Vector3DReadOnly)otherTorque);
        this.setJointForce((Vector3DReadOnly)otherForce);
    }

    @Override
    default public int setJointConfiguration(int rowStart, DMatrix matrix) {
        this.getJointPose().getOrientation().set(rowStart, matrix);
        this.getJointPose().getPosition().set(rowStart + 4, matrix);
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int setJointVelocity(int rowStart, DMatrix matrix) {
        this.getJointTwist().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointAcceleration(int rowStart, DMatrix matrix) {
        this.getJointAcceleration().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointTau(int rowStart, DMatrix matrix) {
        this.getJointWrench().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }
}

