/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;

public interface PlanarJointReadOnly
extends FloatingJointReadOnly {
    public static final int NUMBER_OF_DOFS = 3;

    @Override
    default public int getJointAcceleration(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart + 0, 0, this.getJointAcceleration().getAngularPartY());
        matrixToPack.set(rowStart + 1, 0, this.getJointAcceleration().getLinearPartX());
        matrixToPack.set(rowStart + 2, 0, this.getJointAcceleration().getLinearPartZ());
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int getJointTau(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart + 0, 0, this.getJointWrench().getAngularPartY());
        matrixToPack.set(rowStart + 1, 0, this.getJointWrench().getLinearPartX());
        matrixToPack.set(rowStart + 2, 0, this.getJointWrench().getLinearPartZ());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointConfiguration(int rowStart, DMatrix matrixToPack) {
        int index = rowStart;
        matrixToPack.set(index++, 0, this.getJointPose().getPitch());
        matrixToPack.set(index++, 0, this.getJointPose().getX());
        matrixToPack.set(index++, 0, this.getJointPose().getZ());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getJointVelocity(int rowStart, DMatrix matrixToPack) {
        matrixToPack.set(rowStart + 0, 0, this.getJointTwist().getAngularPartY());
        matrixToPack.set(rowStart + 1, 0, this.getJointTwist().getLinearPartX());
        matrixToPack.set(rowStart + 2, 0, this.getJointTwist().getLinearPartZ());
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int getDegreesOfFreedom() {
        return 3;
    }

    @Override
    default public int getConfigurationMatrixSize() {
        return this.getDegreesOfFreedom();
    }
}

