/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms.interfaces;

import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public interface RigidBodyTwistProvider {
    public TwistReadOnly getTwistOfBody(RigidBodyReadOnly var1);

    public TwistReadOnly getRelativeTwist(RigidBodyReadOnly var1, RigidBodyReadOnly var2);

    default public FrameVector3DReadOnly getLinearVelocityOfBodyFixedPoint(RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
        return this.getLinearVelocityOfBodyFixedPoint(null, body, bodyFixedPoint);
    }

    public FrameVector3DReadOnly getLinearVelocityOfBodyFixedPoint(RigidBodyReadOnly var1, RigidBodyReadOnly var2, FramePoint3DReadOnly var3);

    public ReferenceFrame getInertialFrame();

    public static RigidBodyTwistProvider toRigidBodyTwistProvider(final Function<RigidBodyReadOnly, TwistReadOnly> twistFunction, final ReferenceFrame inertialFrame) {
        return new RigidBodyTwistProvider(){
            private final Twist twist = new Twist();
            private final FrameVector3D linearVelocity = new FrameVector3D();

            @Override
            public TwistReadOnly getTwistOfBody(RigidBodyReadOnly body) {
                return (TwistReadOnly)twistFunction.apply(body);
            }

            @Override
            public TwistReadOnly getRelativeTwist(RigidBodyReadOnly base, RigidBodyReadOnly body) {
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                TwistReadOnly immutableBaseTwist = this.getTwistOfBody(base);
                if (immutableBaseTwist == null) {
                    return null;
                }
                this.twist.setIncludingFrame(immutableBaseTwist);
                TwistReadOnly immutableBodyTwist = this.getTwistOfBody(body);
                if (immutableBodyTwist == null) {
                    return null;
                }
                this.twist.changeFrame(bodyFrame);
                this.twist.sub(immutableBodyTwist);
                this.twist.invert();
                return this.twist;
            }

            @Override
            public FrameVector3DReadOnly getLinearVelocityOfBodyFixedPoint(RigidBodyReadOnly base, RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
                if (base != null) {
                    this.getRelativeTwist(base, body).getLinearVelocityAt(bodyFixedPoint, (FrameVector3DBasics)this.linearVelocity);
                } else {
                    this.getTwistOfBody(body).getLinearVelocityAt(bodyFixedPoint, (FrameVector3DBasics)this.linearVelocity);
                }
                return this.linearVelocity;
            }

            @Override
            public ReferenceFrame getInertialFrame() {
                return inertialFrame;
            }
        };
    }
}

