/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;

public interface TwistReadOnly
extends SpatialMotionReadOnly {
    default public void getLinearVelocityAt(FramePoint3DReadOnly observerPosition, FrameVector3DBasics linearVelocityToPack) {
        linearVelocityToPack.setReferenceFrame(this.getReferenceFrame());
        this.getLinearVelocityAt(observerPosition, (FixedFrameVector3DBasics)linearVelocityToPack);
    }

    default public void getLinearVelocityAt(FramePoint3DReadOnly observerPosition, FixedFrameVector3DBasics linearVelocityToPack) {
        observerPosition.checkReferenceFrameMatch(this.getReferenceFrame());
        linearVelocityToPack.set((FrameTuple3DReadOnly)observerPosition);
        linearVelocityToPack.cross((Tuple3DReadOnly)this.getAngularPart(), (Tuple3DReadOnly)linearVelocityToPack);
        linearVelocityToPack.add((FrameTuple3DReadOnly)this.getLinearPart());
    }

    default public double dot(WrenchReadOnly wrench) {
        this.checkBodyFrameMatch(wrench.getBodyFrame());
        return SpatialMotionReadOnly.super.dot(wrench);
    }

    default public boolean geometricallyEquals(TwistReadOnly other, double epsilon) {
        this.checkReferenceFrameMatch(other);
        if (!this.getAngularPart().geometricallyEquals(other.getAngularPart(), epsilon)) {
            return false;
        }
        return this.getLinearPart().geometricallyEquals(other.getLinearPart(), epsilon);
    }
}

