/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;

public interface FixedFrameSpatialForceBasics
extends SpatialForceReadOnly,
FixedFrameSpatialVectorBasics {
    @Override
    public FixedFrameVector3DBasics getAngularPart();

    @Override
    public FixedFrameVector3DBasics getLinearPart();

    default public void set(Vector3DReadOnly angularPart, Vector3DReadOnly linearPart, Point3DReadOnly pointOfApplication) {
        this.getLinearPart().set((Tuple3DReadOnly)linearPart);
        if (angularPart != null) {
            this.getAngularPart().set((Tuple3DReadOnly)angularPart);
        } else {
            this.getAngularPart().setToZero();
        }
        this.addCrossToAngularPart((Tuple3DReadOnly)pointOfApplication, (Tuple3DReadOnly)linearPart);
    }

    default public void set(ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart, Point3DReadOnly pointOfApplication) {
        this.checkReferenceFrameMatch(expressedInFrame);
        this.set(angularPart, linearPart, pointOfApplication);
    }

    default public void set(FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart, FramePoint3DReadOnly pointOfApplication) {
        if (angularPart != null) {
            linearPart.checkReferenceFrameMatch((ReferenceFrameHolder)angularPart);
        }
        linearPart.checkReferenceFrameMatch((ReferenceFrameHolder)pointOfApplication);
        this.set(linearPart.getReferenceFrame(), (Vector3DReadOnly)angularPart, (Vector3DReadOnly)linearPart, (Point3DReadOnly)pointOfApplication);
    }

    @Override
    default public void applyTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransformReadOnly)) {
            throw new UnsupportedOperationException("The feature applyTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyTransform((RigidBodyTransformReadOnly)transform);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        if (!(transform instanceof RigidBodyTransformReadOnly)) {
            throw new UnsupportedOperationException("The feature applyInverseTransform is not supported for the transform of the type: " + transform.getClass().getSimpleName());
        }
        this.applyInverseTransform((RigidBodyTransformReadOnly)transform);
    }

    default public void applyTransform(RigidBodyTransformReadOnly transform) {
        if (transform.hasRotation()) {
            this.getAngularPart().applyTransform((Transform)transform);
            this.getLinearPart().applyTransform((Transform)transform);
        }
        if (transform.hasTranslation()) {
            this.addCrossToAngularPart(transform.getTranslation(), (Tuple3DReadOnly)this.getLinearPart());
        }
    }

    default public void applyInverseTransform(RigidBodyTransformReadOnly transform) {
        if (transform.hasTranslation()) {
            this.addCrossToAngularPart((Tuple3DReadOnly)this.getLinearPart(), transform.getTranslation());
        }
        if (transform.hasRotation()) {
            this.getAngularPart().applyInverseTransform((Transform)transform);
            this.getLinearPart().applyInverseTransform((Transform)transform);
        }
    }
}

