/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoIOTools;
import us.ihmc.mecano.tools.MecanoTools;

public class SpatialInertia
implements SpatialInertiaBasics,
GeometryObject<SpatialInertia> {
    private ReferenceFrame bodyFrame;
    private ReferenceFrame expressedInFrame;
    private final Matrix3D momentOfInertia = new Matrix3D();
    private double mass = 0.0;
    private final FixedFrameVector3DBasics centerOfMassOffset = MecanoFactories.newFixedFrameVector3DBasics(this);
    private final Point3D translation = new Point3D();
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();

    public SpatialInertia() {
        this.bodyFrame = null;
        this.expressedInFrame = null;
    }

    public SpatialInertia(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame) {
        this.setToZero(bodyFrame, expressedInFrame);
    }

    public SpatialInertia(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Matrix3DReadOnly momentOfInertia, double mass) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, momentOfInertia, mass);
    }

    public SpatialInertia(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, double Ixx, double Iyy, double Izz, double mass) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, Ixx, Iyy, Izz, mass);
    }

    public SpatialInertia(ReferenceFrame bodyFrame, ReferenceFrame expressedInFrame, Matrix3DReadOnly momentOfInertia, double mass, Tuple3DReadOnly centerOfMassOffset) {
        this.setIncludingFrame(bodyFrame, expressedInFrame, momentOfInertia, mass, centerOfMassOffset);
    }

    public SpatialInertia(SpatialInertiaReadOnly other) {
        this.setIncludingFrame(other);
    }

    public void set(SpatialInertia other) {
        SpatialInertiaBasics.super.set(other);
    }

    public void setReferenceFrame(ReferenceFrame expressedInFrame) {
        this.expressedInFrame = expressedInFrame;
    }

    @Override
    public void setBodyFrame(ReferenceFrame bodyFrame) {
        this.bodyFrame = bodyFrame;
    }

    @Override
    public void setMass(double mass) {
        this.mass = mass;
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        if (desiredFrame == this.expressedInFrame) {
            return;
        }
        this.expressedInFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, desiredFrame);
        this.applyTransform(this.transformToDesiredFrame);
        this.expressedInFrame = desiredFrame;
    }

    @Override
    public void applyTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyTransform((RigidBodyTransform)transform);
        } else {
            this.translation.setToZero();
            this.translation.applyTransform(transform);
            this.momentOfInertia.applyTransform(transform);
            this.centerOfMassOffset.applyTransform(transform);
            MecanoTools.translateMomentOfInertia(this.mass, (Tuple3DReadOnly)this.centerOfMassOffset, false, (Tuple3DReadOnly)this.translation, (Matrix3DBasics)this.momentOfInertia);
            this.centerOfMassOffset.add((Tuple3DReadOnly)this.translation);
        }
    }

    @Override
    public void applyInverseTransform(Transform transform) {
        if (transform instanceof RigidBodyTransform) {
            this.applyInverseTransform((RigidBodyTransform)transform);
        } else {
            this.translation.setToZero();
            this.translation.applyInverseTransform(transform);
            this.momentOfInertia.applyInverseTransform(transform);
            this.centerOfMassOffset.applyInverseTransform(transform);
            MecanoTools.translateMomentOfInertia(this.mass, (Tuple3DReadOnly)this.centerOfMassOffset, true, (Tuple3DReadOnly)this.translation, (Matrix3DBasics)this.momentOfInertia);
            this.centerOfMassOffset.add((Tuple3DReadOnly)this.translation);
        }
    }

    public ReferenceFrame getReferenceFrame() {
        return this.expressedInFrame;
    }

    @Override
    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    @Override
    public Matrix3DBasics getMomentOfInertia() {
        return this.momentOfInertia;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public FixedFrameVector3DBasics getCenterOfMassOffset() {
        return this.centerOfMassOffset;
    }

    public boolean epsilonEquals(SpatialInertia other, double epsilon) {
        return SpatialInertiaBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(SpatialInertia other, double epsilon) {
        return SpatialInertiaBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialInertiaReadOnly) {
            return SpatialInertiaBasics.super.equals((SpatialInertiaReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return MecanoIOTools.getSpatialInertiaString(this);
    }
}

